/*
 * Decompiled with CFR 0.152.
 */
package terrails.colorfulhearts.forge.compat;

import elucent.eidolon.capability.ISoul;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.ForgeRegistries;
import terrails.colorfulhearts.CColorfulHearts;
import terrails.colorfulhearts.api.forge.event.ForgeHeartRegistryEvent;
import terrails.colorfulhearts.api.forge.event.ForgeHeartRenderEvent;
import terrails.colorfulhearts.api.heart.drawing.HeartDrawing;
import terrails.colorfulhearts.api.heart.drawing.OverlayHeart;

public class EidolonRepraisedCompat {
    private static final ResourceLocation EIDOLON_HEARTS = new ResourceLocation("eidolon", "hearts");
    private static final ResourceLocation ICONS_TEXTURE = new ResourceLocation("eidolon", "textures/gui/icons.png");
    private static final Minecraft client = Minecraft.m_91087_();

    public EidolonRepraisedCompat(IEventBus bus) {
        bus.addListener(this::registerEffectHeart);
        MinecraftForge.EVENT_BUS.addListener(this::cancelOverlay);
        MinecraftForge.EVENT_BUS.addListener(this::renderEtherealHearts);
    }

    private void cancelOverlay(RenderGuiOverlayEvent.Pre event) {
        if (event.getOverlay().id().equals((Object)EIDOLON_HEARTS)) {
            event.setCanceled(true);
        }
    }

    public void registerEffectHeart(ForgeHeartRegistryEvent event) {
        final ResourceLocation chilledId = new ResourceLocation("eidolon", "chilled");
        ForgeRegistries.MOB_EFFECTS.getHolder(chilledId).ifPresent(effectHolder -> {
            CColorfulHearts.LOGGER.info("Registering custom hearts for chilled from mod eidolon");
            HeartDrawing drawing = new HeartDrawing(){

                @Override
                public void draw(GuiGraphics guiGraphics, int x, int y, boolean half, boolean hardcore, boolean highlight) {
                    guiGraphics.m_280218_(ICONS_TEXTURE, x, y, half ? 9 : 0, 0, 9, 9);
                }

                @Override
                public ResourceLocation getId() {
                    return chilledId;
                }
            };
            event.registerOverlayHeart(OverlayHeart.build(chilledId, player -> player.m_21023_((MobEffect)effectHolder.get())).addHealth(drawing).transparent().finish());
            CColorfulHearts.LOGGER.debug("Registered custom hearts for chilled from mod eidolon");
        });
    }

    public void renderEtherealHearts(ForgeHeartRenderEvent.Post event) {
        int overflown;
        int top;
        LocalPlayer player = EidolonRepraisedCompat.client.f_91074_;
        if (player == null) {
            return;
        }
        Optional capability = player.getCapability(ISoul.INSTANCE).resolve();
        if (capability.isEmpty()) {
            return;
        }
        ISoul soul = (ISoul)capability.get();
        float maxEtherealHealth = soul.getMaxEtherealHealth();
        if (maxEtherealHealth == 0.0f) {
            return;
        }
        float etherealHealth = soul.getEtherealHealth();
        int maxEtherealHearts = Mth.m_14167_((float)(maxEtherealHealth / 2.0f));
        int maxHealth = Mth.m_14167_((float)Math.max(player.m_21233_(), player.m_21223_()));
        int absorption = Mth.m_14167_((float)player.m_6103_());
        int healthHearts = Math.min(10, Mth.m_14167_((float)((float)maxHealth / 2.0f)));
        int maxAbsorbing = maxHealth >= 19 ? 20 : 40 - maxHealth - maxHealth % 2;
        int absorptionHearts = Mth.m_14167_((float)((float)Math.min(maxAbsorbing, absorption) / 2.0f));
        ForgeGui gui = (ForgeGui)EidolonRepraisedCompat.client.f_91065_;
        int vanillaHearts = healthHearts + absorptionHearts;
        int n = top = vanillaHearts > 10 ? 20 : 10;
        if (vanillaHearts + maxEtherealHearts > top && (overflown = top - vanillaHearts + maxEtherealHearts) > 0) {
            gui.leftHeight += Mth.m_14167_((float)((float)maxEtherealHearts / 10.0f)) * 10;
        }
        etherealHealth += (float)Math.min(40, maxHealth + absorption);
        int xPos = event.getX();
        int yPos = event.getY();
        GuiGraphics guiGraphics = event.getGuiGraphics();
        int blinkingOffset = event.isBlinking() ? 9 : 0;
        for (int i = healthHearts + absorptionHearts + maxEtherealHearts - 1; i >= healthHearts + absorptionHearts; --i) {
            int x = xPos + i % 10 * 8;
            int y = yPos - i / 10 * 10;
            event.getGuiGraphics().m_280218_(ICONS_TEXTURE, x, y, blinkingOffset, 18, 9, 9);
            if ((float)(i * 2 + 1) < etherealHealth) {
                guiGraphics.m_280218_(ICONS_TEXTURE, x, y, 0, 9, 9, 9);
                continue;
            }
            if ((float)(i * 2 + 1) != etherealHealth) continue;
            guiGraphics.m_280218_(ICONS_TEXTURE, x, y, 9, 9, 9, 9);
        }
    }
}

