/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.Tools;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class JSonTools {
    public static Optional<JsonElement> getElement(JsonObject element, String name) {
        JsonElement el = element.get(name);
        if (el != null) {
            return Optional.of(el);
        }
        return Optional.empty();
    }

    public static int get(JsonObject object, String name, int def) {
        if (object.has(name)) {
            return object.get(name).getAsInt();
        }
        return def;
    }

    public static boolean get(JsonObject object, String name, boolean def) {
        if (object.has(name)) {
            return object.get(name).getAsBoolean();
        }
        return def;
    }

    public static String get(JsonObject object, String name, String def) {
        if (object.has(name)) {
            return object.get(name).getAsString();
        }
        return def;
    }

    public static void put(JsonObject object, String name, Integer value, Integer def) {
        if (value == null) {
            return;
        }
        if (value.equals(def)) {
            return;
        }
        object.add(name, (JsonElement)new JsonPrimitive((Number)value));
    }

    public static void put(JsonObject object, String name, Boolean value, Boolean def) {
        if (value == null) {
            return;
        }
        if (value.equals(def)) {
            return;
        }
        object.add(name, (JsonElement)new JsonPrimitive(value));
    }

    public static void put(JsonObject object, String name, String value, String def) {
        if (value == null) {
            return;
        }
        if (value.equals(def)) {
            return;
        }
        object.add(name, (JsonElement)new JsonPrimitive(value));
    }

    public static void putStringList(JsonObject object, String name, @Nullable List<String> list) {
        if (list == null) {
            return;
        }
        if (list.size() == 1) {
            object.add(name, (JsonElement)new JsonPrimitive(list.get(0)));
        } else {
            JsonArray array = new JsonArray();
            for (String s : list) {
                array.add((JsonElement)new JsonPrimitive(s));
            }
            object.add(name, (JsonElement)array);
        }
    }

    @Nullable
    public static List<String> getStringList(JsonObject object, String name) {
        if (!object.has(name)) {
            return null;
        }
        if (object.get(name).isJsonArray()) {
            JsonArray array = object.getAsJsonArray(name);
            ArrayList<String> result = new ArrayList<String>();
            for (JsonElement element : array) {
                result.add(element.getAsString());
            }
            return result;
        }
        return Collections.singletonList(object.get(name).getAsString());
    }

    public static JsonObject itemStackToJson(ItemStack item) {
        JsonObject object = new JsonObject();
        object.add("item", (JsonElement)new JsonPrimitive(Tools.getId(item).toString()));
        if (item.m_41613_() != 1) {
            object.add("amount", (JsonElement)new JsonPrimitive((Number)item.m_41613_()));
        }
        if (item.m_41782_()) {
            String string = item.m_41783_().toString();
            object.add("nbt", (JsonElement)new JsonPrimitive(string));
        }
        return object;
    }

    public static ItemStack jsonToItemStack(JsonObject obj) {
        String itemName = obj.get("item").getAsString();
        Item item = Tools.getItem(new ResourceLocation(itemName));
        int amount = 1;
        if (obj.has("amount")) {
            amount = obj.get("amount").getAsInt();
        }
        ItemStack stack = new ItemStack((ItemLike)item, amount);
        if (obj.has("nbt")) {
            try {
                CompoundTag nbt = TagParser.m_129359_((String)obj.get("nbt").getAsString());
                stack.m_41751_(nbt);
            }
            catch (CommandSyntaxException e) {
                Logging.logError("Parsing error", e);
            }
        }
        return stack;
    }
}

