/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.api.altar;

import elucent.eidolon.api.altar.AltarEntry;
import elucent.eidolon.common.block.TableBlockBase;
import elucent.eidolon.registries.AltarEntries;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;

public class AltarInfo {
    Block icon = null;
    Block altar = null;
    final Map<ResourceLocation, AltarAttributes> attributes = new HashMap<ResourceLocation, AltarAttributes>();

    public static Set<BlockPos> getAltarPositions(Level world, BlockPos pos) {
        HashSet<BlockPos> result = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> visit = new ArrayDeque<BlockPos>();
        BlockState below = world.m_8055_(pos.m_7495_());
        Block b = below.m_60734_();
        if (below.m_60734_() instanceof TableBlockBase) {
            visit.add(pos.m_7495_());
        }
        while (!visit.isEmpty()) {
            BlockPos visited = (BlockPos)visit.remove();
            if (result.contains(visited)) continue;
            result.add(visited);
            for (Direction d : BlockStateProperties.f_61374_.m_6908_()) {
                if (world.m_8055_(visited.m_121945_(d)).m_60734_() != b || result.contains(visited.m_121945_(d))) continue;
                visit.add(visited.m_121945_(d));
            }
        }
        return result;
    }

    public static AltarInfo getAltarInfo(Level world, BlockPos pos) {
        AltarInfo info = new AltarInfo();
        info.icon = world.m_8055_(pos).m_60734_();
        Set<BlockPos> altarPositions = AltarInfo.getAltarPositions(world, pos);
        for (BlockPos p : altarPositions) {
            BlockState state;
            AltarEntry entry;
            if (info.altar == null) {
                info.altar = world.m_8055_(p).m_60734_();
            }
            if ((entry = AltarEntries.find((state = world.m_8055_(p.m_7494_())).m_60734_())) == null) continue;
            entry.apply(info);
        }
        return info;
    }

    protected void increaseCapacity(ResourceLocation key, double value) {
        AltarAttributes attrs = this.attributes.computeIfAbsent(key, k -> new AltarAttributes());
        attrs.capacity = Math.max(attrs.capacity, value);
    }

    protected void increasePower(ResourceLocation key, double value) {
        AltarAttributes attrs = this.attributes.computeIfAbsent(key, k -> new AltarAttributes());
        attrs.power = Math.max(attrs.power, value);
    }

    public double getCapacity() {
        double sum = 0.0;
        for (Map.Entry<ResourceLocation, AltarAttributes> key : this.attributes.entrySet()) {
            sum += key.getValue().capacity;
        }
        return sum;
    }

    public double getPower() {
        double sum = 0.0;
        for (Map.Entry<ResourceLocation, AltarAttributes> key : this.attributes.entrySet()) {
            sum += key.getValue().power;
        }
        return sum;
    }

    public Block getIcon() {
        return this.icon;
    }

    public Block getAltar() {
        return this.altar;
    }

    public boolean hasKey(ResourceLocation loc) {
        return this.attributes.containsKey(loc);
    }

    static class AltarAttributes {
        public double capacity = 0.0;
        public double power = 0.0;
    }
}

