/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.codex;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import elucent.eidolon.api.spells.Rune;
import elucent.eidolon.api.spells.Sign;
import elucent.eidolon.client.ClientRegistry;
import elucent.eidolon.codex.Category;
import elucent.eidolon.codex.Chapter;
import elucent.eidolon.codex.CodexChapters;
import elucent.eidolon.codex.Page;
import elucent.eidolon.codex.SignIndexPage;
import elucent.eidolon.network.AttemptCastPacket;
import elucent.eidolon.network.Networking;
import elucent.eidolon.util.ClientInfo;
import elucent.eidolon.util.RenderUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class CodexGui
extends Screen {
    public static final CodexGui DUMMY = new CodexGui();
    public static final ResourceLocation CODEX_BACKGROUND = new ResourceLocation("eidolon", "textures/gui/codex_bg.png");
    static final int xSize = 312;
    static final int ySize = 208;
    final List<Sign> chant = new ArrayList<Sign>();
    Rune hoveredRune = null;
    Chapter currentChapter;
    Chapter lastChapter = this.currentChapter = CodexChapters.NATURE_INDEX;
    int currentPage = 0;
    static CodexGui INSTANCE = null;
    boolean hasTooltip = false;
    Matrix4f tooltipMatrix = null;
    Component tooltipText = null;
    int tooltipX = 0;
    int tooltipY = 0;

    public static CodexGui getInstance() {
        for (Category cat : CodexChapters.categories) {
            cat.reset();
        }
        return INSTANCE != null ? INSTANCE : (INSTANCE = new CodexGui());
    }

    protected CodexGui() {
        super((Component)Component.m_237115_((String)"gui.eidolon.codex.title"));
    }

    public static void blit(GuiGraphics guiGraphics, int pX, int pY, float pUOffset, float pVOffset, int pWidth, int pHeight, int pTextureWidth, int pTextureHeight) {
        guiGraphics.m_280163_(CODEX_BACKGROUND, pX, pY, pUOffset, pVOffset, pWidth, pHeight, pTextureWidth, pTextureHeight);
    }

    public static void openToEntry(Chapter docEntry, int i) {
        CodexGui codexGui;
        if (docEntry == null) {
            CodexGui.getInstance().m_7379_();
            return;
        }
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof CodexGui) {
            codexGui = (CodexGui)screen;
            if (codexGui.currentChapter == docEntry) {
                return;
            }
        }
        codexGui = CodexGui.getInstance();
        codexGui.changeChapter(docEntry);
        codexGui.currentPage = i;
        Minecraft.m_91087_().m_91152_((Screen)codexGui);
    }

    protected void resetPages() {
        Page left = this.currentChapter.get(this.currentPage);
        Page right = this.currentChapter.get(this.currentPage + 1);
        if (left != null) {
            left.reset();
        }
        if (right != null) {
            right.reset();
        }
    }

    protected void changeChapter(Chapter next) {
        this.lastChapter = this.currentChapter;
        this.currentChapter = next;
        this.currentPage = 0;
    }

    public void addToChant(Sign rune) {
        if (this.chant.size() < 18) {
            this.chant.add(rune);
        }
    }

    protected void renderChant(@NotNull GuiGraphics mStack, int x, int y, int mouseX, int mouseY, float pticks) {
        int chantWidth = 32 + 24 * this.chant.size();
        int baseX = x + 156 - chantWidth / 2;
        int baseY = y + 180;
        RenderSystem.enableBlend();
        int bgx = baseX;
        CodexGui.blit(mStack, bgx, baseY, 256.0f, 208.0f, 16, 32, 512, 512);
        bgx += 16;
        for (int i = 0; i < this.chant.size(); ++i) {
            CodexGui.blit(mStack, bgx, baseY, 272.0f, 208.0f, 24, 32, 512, 512);
            CodexGui.blit(mStack, bgx, baseY, 312.0f, 208.0f, 24, 24, 512, 512);
            bgx += 24;
        }
        CodexGui.blit(mStack, bgx, baseY, 296.0f, 208.0f, 16, 32, 512, 512);
        boolean chantHover = mouseX >= (bgx += 24) && mouseY >= baseY - 4 && mouseX <= bgx + 32 && mouseY <= baseY + 28;
        CodexGui.blit(mStack, bgx, baseY - 4, 336.0f, chantHover ? 240.0f : 208.0f, 32, 32, 512, 512);
        boolean cancelHover = mouseX >= (bgx += 36) && mouseY >= baseY - 4 && mouseX <= bgx + 32 && mouseY <= baseY + 28;
        CodexGui.blit(mStack, bgx, baseY - 4, 368.0f, cancelHover ? 240.0f : 208.0f, 32, 32, 512, 512);
        if (chantHover) {
            mStack.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"eidolon.codex.chant_hover"), mouseX, mouseY);
        }
        if (cancelHover) {
            mStack.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"eidolon.codex.cancel_hover"), mouseX, mouseY);
        }
        RenderSystem.enableBlend();
        RenderSystem.setShader(ClientRegistry::getGlowingSpriteShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        bgx = baseX + 16;
        MultiBufferSource.BufferSource buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
        for (Sign sign : this.chant) {
            RenderUtil.litQuad(mStack.m_280168_(), (MultiBufferSource)buffersource, bgx + 4, baseY + 4, 16.0, 16.0, sign.getRed(), sign.getGreen(), sign.getBlue(), (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(sign.getSprite()));
            buffersource.m_109911_();
            bgx += 24;
        }
        bgx = baseX + 16;
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        for (int i = 0; i < this.chant.size(); ++i) {
            float flicker = 0.75f + 0.25f * (float)Math.sin(Math.toRadians(12.0f * ClientInfo.getClientPartialTicks() - 360.0f * (float)i / (float)this.chant.size()));
            Sign sign = this.chant.get(i);
            RenderUtil.litQuad(mStack.m_280168_(), (MultiBufferSource)buffersource, bgx + 4, baseY + 4, 16.0, 16.0, sign.getRed() * flicker, sign.getGreen() * flicker, sign.getBlue() * flicker, (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(sign.getSprite()));
            buffersource.m_109911_();
            bgx += 24;
        }
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)f_279548_);
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int v;
        int y;
        int x;
        if (this.currentChapter == null) {
            this.currentChapter = CodexChapters.NATURE_INDEX;
        }
        this.hasTooltip = false;
        this.f_96541_ = Minecraft.m_91087_();
        this.m_280273_(guiGraphics);
        Minecraft mc = this.f_96541_;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)CODEX_BACKGROUND);
        this.f_96543_ = mc.m_91268_().m_85445_();
        this.f_96544_ = mc.m_91268_().m_85446_();
        int guiLeft = (this.f_96543_ - 312) / 2;
        int guiTop = (this.f_96544_ - 208) / 2;
        guiGraphics.m_280163_(CODEX_BACKGROUND, guiLeft, guiTop, 0.0f, 256.0f, 312, 208, 512, 512);
        for (int i = 0; i < CodexChapters.categories.size(); ++i) {
            int y2 = guiTop + 28 + i % 8 * 20;
            CodexChapters.categories.get(i).draw(this, guiGraphics, guiLeft + (i >= 8 ? 304 : 8), y2, i >= 8, mouseX, mouseY);
        }
        guiGraphics.m_280163_(CODEX_BACKGROUND, guiLeft, guiTop, 0.0f, 0.0f, 312, 208, 512, 512);
        Page left = this.currentChapter.get(this.currentPage);
        Page right = this.currentChapter.get(this.currentPage + 1);
        if (left != null) {
            left.fullRender(this, guiGraphics, guiLeft + 14, guiTop + 24, mouseX, mouseY);
        }
        if (right != null) {
            right.fullRender(this, guiGraphics, guiLeft + 170, guiTop + 24, mouseX, mouseY);
        }
        if (this.currentPage > 0) {
            x = 10;
            y = 169;
            v = 208;
            if (mouseX >= guiLeft + x && mouseY >= guiTop + y && mouseX <= guiLeft + x + 32 && mouseY <= guiTop + y + 16) {
                v += 18;
            }
            guiGraphics.m_280163_(CODEX_BACKGROUND, guiLeft + x, guiTop + y, 128.0f, (float)v, 32, 18, 512, 512);
        }
        if (this.currentPage + 2 < this.currentChapter.size()) {
            x = 270;
            y = 169;
            v = 208;
            if (mouseX >= guiLeft + x && mouseY >= guiTop + y && mouseX <= guiLeft + x + 32 && mouseY <= guiTop + y + 16) {
                v += 18;
            }
            guiGraphics.m_280163_(CODEX_BACKGROUND, guiLeft + x, guiTop + y, 160.0f, (float)v, 32, 18, 512, 512);
        }
        if (!this.chant.isEmpty()) {
            this.renderChant(guiGraphics, guiLeft, guiTop, mouseX, mouseY, partialTicks);
        }
        for (int i = 0; i < CodexChapters.categories.size(); ++i) {
            y = guiTop + 28 + i % 8 * 20;
            CodexChapters.categories.get(i).drawTooltip(guiGraphics, guiLeft + (i >= 8 ? 304 : 8), y, i >= 8, mouseX, mouseY);
        }
        if (this.hasTooltip) {
            PoseStack pose = guiGraphics.m_280168_();
            pose.m_85836_();
            pose.m_166856_();
            pose.m_252931_(this.tooltipMatrix);
            guiGraphics.m_280557_(this.f_96547_, this.tooltipText, this.tooltipX, this.tooltipY);
            pose.m_85849_();
        }
    }

    protected boolean interactChant(int x, int y, int mouseX, int mouseY) {
        int chantWidth = 32 + 24 * this.chant.size();
        int baseX = x + 156 - chantWidth / 2;
        int baseY = y + 180;
        int bgx = baseX + chantWidth + 8;
        boolean chantHover = mouseX >= bgx && mouseY >= baseY - 4 && mouseX <= bgx + 32 && mouseY <= baseY + 28;
        boolean cancelHover = mouseX >= (bgx += 36) && mouseY >= baseY - 4 && mouseX <= bgx + 32 && mouseY <= baseY + 28;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (player == null || world == null) {
            return false;
        }
        if (chantHover) {
            Networking.sendToServer(new AttemptCastPacket((Player)player, this.chant));
            this.chant.clear();
            player.m_6330_((SoundEvent)SoundEvents.f_12490_.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.m_7379_();
            return true;
        }
        if (cancelHover) {
            this.chant.clear();
            player.m_6330_((SoundEvent)SoundEvents.f_12490_.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        Minecraft mc = this.getMinecraft();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return false;
        }
        if (button == 0) {
            int y;
            int x;
            this.f_96543_ = mc.m_91268_().m_85445_();
            this.f_96544_ = mc.m_91268_().m_85446_();
            int guiLeft = (this.f_96543_ - 312) / 2;
            int guiTop = (this.f_96544_ - 208) / 2;
            if (this.currentPage > 0) {
                x = guiLeft + 10;
                y = guiTop + 169;
                if (mouseX >= (double)x && mouseY >= (double)y && mouseX <= (double)(x + 32) && mouseY <= (double)(y + 16)) {
                    this.currentPage -= 2;
                    player.m_6330_(SoundEvents.f_11713_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    this.resetPages();
                    return true;
                }
            }
            if (this.currentPage + 2 < this.currentChapter.size()) {
                x = guiLeft + 270;
                y = guiTop + 169;
                if (mouseX >= (double)x && mouseY >= (double)y && mouseX <= (double)(x + 32) && mouseY <= (double)(y + 16)) {
                    this.currentPage += 2;
                    player.m_6330_(SoundEvents.f_11713_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    this.resetPages();
                    return true;
                }
            }
            for (int i = 0; i < CodexChapters.categories.size(); ++i) {
                y = guiTop + 28 + i % 8 * 20;
                if (!CodexChapters.categories.get(i).click(this, guiLeft + (i >= 8 ? 304 : 8), y, i >= 8, (int)mouseX, (int)mouseY)) continue;
                return true;
            }
            Page left = this.currentChapter.get(this.currentPage);
            Page right = this.currentChapter.get(this.currentPage + 1);
            if (left != null && left.click(this, guiLeft + 14, guiTop + 24, (int)mouseX, (int)mouseY)) {
                return true;
            }
            if (right != null && right.click(this, guiLeft + 170, guiTop + 24, (int)mouseX, (int)mouseY)) {
                return true;
            }
            return !this.chant.isEmpty() && this.interactChant(guiLeft, guiTop, (int)mouseX, (int)mouseY);
        }
        if (button == 1) {
            if (!this.chant.isEmpty() && this.currentChapter.get(this.currentPage) instanceof SignIndexPage) {
                this.chant.remove(this.chant.size() - 1);
                player.m_6330_((SoundEvent)SoundEvents.f_12490_.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                return true;
            }
            if (!(this.currentChapter.get(this.currentPage) instanceof SignIndexPage)) {
                this.currentChapter = this.lastChapter;
                this.currentPage = 0;
                player.m_6330_(SoundEvents.f_11713_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                this.resetPages();
                return true;
            }
        }
        return false;
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        LocalPlayer player = this.getMinecraft().f_91074_;
        if (player == null) {
            return false;
        }
        if (pDelta < 0.0) {
            if (this.currentPage + 2 < this.currentChapter.size()) {
                ++this.currentPage;
                player.m_6330_(SoundEvents.f_11713_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                this.resetPages();
                return true;
            }
        } else if (pDelta > 0.0 && this.currentPage > 0) {
            --this.currentPage;
            player.m_6330_(SoundEvents.f_11713_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.resetPages();
            return true;
        }
        return super.m_6050_(pMouseX, pMouseY, pDelta);
    }
}

