/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.deity;

import elucent.eidolon.api.deity.Deity;
import elucent.eidolon.capability.Facts;
import elucent.eidolon.common.deity.DeityLocks;
import elucent.eidolon.registries.Signs;
import elucent.eidolon.util.KnowledgeUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class LightDeity
extends Deity {
    public LightDeity(ResourceLocation id, int red, int green, int blue) {
        super(id, red, green, blue);
        this.progression.add(new Deity.Stage(DeityLocks.BASIC_INCENSE_PRAYER, 3, true).requirement(new Deity.ResearchRequirement(DeityLocks.BASIC_INCENSE_PRAYER))).add(new Deity.Stage(DeityLocks.LIGHT_TOUCH, 10, false)).add(new Deity.Stage(DeityLocks.HEAL_VILLAGER, 15, true).requirement(new Deity.ResearchRequirement(DeityLocks.HEAL_VILLAGER))).add(new Deity.Stage(DeityLocks.CURE_ZOMBIE, 35, true).requirement(new Deity.ResearchRequirement(DeityLocks.CURE_ZOMBIE))).add(new Deity.Stage(DeityLocks.SMITE_UNDEAD, 50, true).requirement(new Deity.ResearchRequirement(DeityLocks.SMITE_UNDEAD))).setMax(100);
    }

    @Override
    public void onReputationUnlock(Player player, ResourceLocation lock) {
        if (lock.equals((Object)DeityLocks.BASIC_INCENSE_PRAYER)) {
            KnowledgeUtil.grantSign((Entity)player, Signs.SOUL_SIGN);
        } else if (lock.equals((Object)DeityLocks.LIGHT_TOUCH) && player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            sp.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237115_((String)"eidolon.title.new_fact")));
        } else if (lock.equals((Object)DeityLocks.HEAL_VILLAGER)) {
            KnowledgeUtil.grantSign((Entity)player, Signs.MIND_SIGN);
        } else if (lock.equals((Object)DeityLocks.CURE_ZOMBIE)) {
            KnowledgeUtil.grantSign((Entity)player, Signs.DEATH_SIGN);
        } else if (lock.equals((Object)DeityLocks.SMITE_UNDEAD)) {
            KnowledgeUtil.grantSign((Entity)player, Signs.WARDING_SIGN);
        }
    }

    @Override
    public void onReputationLock(Player player, ResourceLocation lock) {
        if (lock.equals((Object)DeityLocks.BASIC_INCENSE_PRAYER)) {
            KnowledgeUtil.grantSign((Entity)player, Signs.FLAME_SIGN);
        } else if (lock.equals((Object)DeityLocks.HEAL_VILLAGER)) {
            KnowledgeUtil.grantFact((Entity)player, Facts.VILLAGER_HEALING);
        } else if (lock.equals((Object)DeityLocks.CURE_ZOMBIE)) {
            KnowledgeUtil.grantSign((Entity)player, Signs.HARMONY_SIGN);
            KnowledgeUtil.grantFact((Entity)player, Facts.ZOMBIE_CURE);
        } else if (lock.equals((Object)DeityLocks.SMITE_UNDEAD)) {
            KnowledgeUtil.grantFact((Entity)player, Facts.SMITE);
            KnowledgeUtil.grantSign((Entity)player, Signs.MAGIC_SIGN);
        }
    }
}

