/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.item.curio;

import elucent.eidolon.common.item.ItemBase;
import elucent.eidolon.registries.Registry;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.theillusivec4.curios.api.CuriosApi;

public class MindShieldingPlateItem
extends ItemBase {
    static final int LEVEL_FLAG = 0x40000000;

    public MindShieldingPlateItem(Item.Properties properties) {
        super(properties);
        MinecraftForge.EVENT_BUS.addListener(MindShieldingPlateItem::onPotion);
        MinecraftForge.EVENT_BUS.addListener(MindShieldingPlateItem::onClone);
        MinecraftForge.EVENT_BUS.addListener(MindShieldingPlateItem::onDropXP);
    }

    @SubscribeEvent
    public static void onPotion(MobEffectEvent.Applicable event) {
        if (event.getEffectInstance().m_19544_() == MobEffects.f_19604_ && CuriosApi.getCuriosHelper().findFirstCurio(event.getEntity(), (Item)Registry.MIND_SHIELDING_PLATE.get()).isPresent()) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        if ((event.getOriginal().f_36078_ & 0x40000000) != 0) {
            event.getEntity().f_36078_ = event.getOriginal().f_36078_ & 0xBFFFFFFF;
            event.getEntity().f_36080_ = event.getOriginal().f_36080_;
        }
    }

    @SubscribeEvent
    public static void onDropXP(LivingExperienceDropEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (CuriosApi.getCuriosHelper().findFirstCurio(event.getEntity(), (Item)Registry.MIND_SHIELDING_PLATE.get()).isPresent()) {
                player.f_36078_ |= 0x40000000;
                event.setCanceled(true);
            }
        }
    }
}

