/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.spell;

import elucent.eidolon.api.altar.AltarInfo;
import elucent.eidolon.api.spells.Sign;
import elucent.eidolon.capability.IReputation;
import elucent.eidolon.capability.ISoul;
import elucent.eidolon.common.deity.Deities;
import elucent.eidolon.common.deity.DeityLocks;
import elucent.eidolon.common.spell.PrayerSpell;
import elucent.eidolon.common.tile.EffigyTileEntity;
import elucent.eidolon.registries.Registry;
import elucent.eidolon.registries.Signs;
import elucent.eidolon.util.KnowledgeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class ConvertZombieSpell
extends PrayerSpell {
    public ConvertZombieSpell(ResourceLocation resourceLocation, int baseRep, double powerMult, Sign ... signs) {
        super(resourceLocation, Deities.LIGHT_DEITY, 20, baseRep, powerMult, signs);
    }

    @Override
    public boolean canCast(Level world, BlockPos pos, Player player) {
        EntityHitResult result;
        HitResult ray = ConvertZombieSpell.rayTrace((Entity)player, player.getBlockReach(), 0.0f, true);
        boolean flag = ray instanceof EntityHitResult && (result = (EntityHitResult)ray).m_82443_() instanceof ZombieVillager;
        EffigyTileEntity effigy = ConvertZombieSpell.getEffigy(world, pos);
        if (effigy == null) {
            player.m_5661_((Component)Component.m_237115_((String)"eidolon.message.no_effigy"), true);
            return false;
        }
        AltarInfo info = AltarInfo.getAltarInfo(world, effigy.m_58899_());
        if (info.getAltar() != Registry.STONE_ALTAR.get() || info.getIcon() != Registry.ELDER_EFFIGY.get()) {
            return false;
        }
        return flag && super.canCast(world, pos, player);
    }

    @Override
    public void cast(Level world, BlockPos pos, Player player) {
        EntityHitResult result;
        Entity entity;
        EffigyTileEntity effigy = ConvertZombieSpell.getEffigy(world, pos);
        if (effigy == null) {
            return;
        }
        HitResult ray = ConvertZombieSpell.rayTrace((Entity)player, player.getBlockReach(), 0.0f, true);
        if (!(ray instanceof EntityHitResult) || !((entity = (result = (EntityHitResult)ray).m_82443_()) instanceof ZombieVillager)) {
            return;
        }
        ZombieVillager villager = (ZombieVillager)entity;
        if (world instanceof ServerLevel) {
            effigy.pray();
            AltarInfo info = AltarInfo.getAltarInfo(world, effigy.m_58899_());
            world.getCapability(IReputation.INSTANCE, null).ifPresent(rep -> {
                rep.pray(player, (PrayerSpell)this, world.m_46467_());
                KnowledgeUtil.grantResearchNoToast((Entity)player, DeityLocks.CURE_ZOMBIE);
                rep.addReputation(player, this.deity.getId(), (double)this.getBaseRep() + this.getPowerMultiplier() * info.getPower());
                ConvertZombieSpell.updateMagic(info, player, world, rep.getReputation(player, this.deity.getId()));
            });
            villager.m_34383_(player.m_20148_(), 20);
            ISoul.expendMana(player, this.getCost());
        } else {
            this.playSuccessSound(world, player, effigy, Signs.HARMONY_SIGN);
        }
    }
}

