/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.spell;

import elucent.eidolon.api.spells.Sign;
import elucent.eidolon.capability.ISoul;
import elucent.eidolon.common.spell.StaticSpell;
import elucent.eidolon.registries.EidolonPotions;
import elucent.eidolon.registries.Researches;
import elucent.eidolon.util.KnowledgeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class FrostSpell
extends StaticSpell {
    public FrostSpell(ResourceLocation name, Sign ... signs) {
        super(name, 20, signs);
    }

    @Override
    public boolean canCast(Level world, BlockPos pos, Player player) {
        BlockHitResult rayTraceResult;
        FluidState fluidState;
        if (!KnowledgeUtil.knowsResearch(player, Researches.FROST_SPELL.getRegistryName())) {
            return false;
        }
        HitResult ray = FrostSpell.rayTrace((Entity)player, player.getBlockReach(), 0.0f, true);
        if (ray instanceof BlockHitResult && (fluidState = world.m_6425_((rayTraceResult = (BlockHitResult)ray).m_82425_())).m_192917_((Fluid)Fluids.f_76193_) && fluidState.m_76170_()) {
            return true;
        }
        return ray instanceof EntityHitResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void cast(Level world, BlockPos pos, Player player) {
        if (world.f_46443_) return;
        HitResult ray = FrostSpell.rayTrace((Entity)player, player.getBlockReach(), 0.0f, true);
        if (ray instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)ray;
            FluidState fluidState = world.m_6425_(blockHitResult.m_82425_());
            if (!fluidState.m_192917_((Fluid)Fluids.f_76193_) || !fluidState.m_76170_()) return;
            world.m_46597_(blockHitResult.m_82425_(), Blocks.f_50126_.m_49966_());
            world.m_5594_(player, pos, SoundEvents.f_144205_, SoundSource.BLOCKS, 1.0f, world.m_213780_().m_188501_() * 0.4f + 0.8f);
        } else {
            EntityHitResult entityHitResult;
            Entity entity;
            if (!(ray instanceof EntityHitResult) || !((entity = (entityHitResult = (EntityHitResult)ray).m_82443_()) instanceof LivingEntity)) return;
            LivingEntity living = (LivingEntity)entity;
            living.m_7292_(new MobEffectInstance((MobEffect)EidolonPotions.CHILLED_EFFECT.get(), 200));
        }
        ISoul.expendMana(player, this.getCost());
    }
}

