/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.spell;

import elucent.eidolon.Eidolon;
import elucent.eidolon.api.spells.Sign;
import elucent.eidolon.capability.ISoul;
import elucent.eidolon.common.deity.DeityLocks;
import elucent.eidolon.common.spell.StaticSpell;
import elucent.eidolon.util.EntityUtil;
import elucent.eidolon.util.KnowledgeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class ThrallSpell
extends StaticSpell {
    public static final TagKey<EntityType<?>> ENTHRALL_BLACKLIST = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)Eidolon.prefix("enthrall_blacklist"));
    public static final TagKey<EntityType<?>> ENTHRALL_WHITELIST = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)Eidolon.prefix("enthrall_whitelist"));

    public ThrallSpell(ResourceLocation name, Sign ... signs) {
        super(name, 50, signs);
    }

    @Override
    public boolean canCast(Level world, BlockPos pos, Player player) {
        EntityHitResult result;
        Entity entity;
        HitResult ray = ThrallSpell.rayTrace((Entity)player, player.getBlockReach() + 3.0, 0.0f, false);
        if (ray instanceof EntityHitResult && (entity = (result = (EntityHitResult)ray).m_82443_()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            MobType type = Eidolon.getTrueMobType(living);
            return !living.m_6095_().m_204039_(ENTHRALL_BLACKLIST) && type == MobType.f_21641_ || living.m_6095_().m_204039_(ENTHRALL_WHITELIST);
        }
        return false;
    }

    @Override
    public void cast(Level world, BlockPos pos, Player player) {
        if (world instanceof ServerLevel && player instanceof ServerPlayer) {
            EntityHitResult result;
            Entity entity;
            ServerPlayer sp = (ServerPlayer)player;
            HitResult ray = ThrallSpell.rayTrace((Entity)player, player.getBlockReach() + 3.0, 0.0f, false);
            if (ray instanceof EntityHitResult && (entity = (result = (EntityHitResult)ray).m_82443_()) instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                float actualCost = (float)(2 * this.getCost()) * living.m_21223_() / living.m_21233_();
                player.getCapability(ISoul.INSTANCE).ifPresent(soul -> {
                    if (soul.getMagic() >= actualCost) {
                        soul.takeMagic(actualCost);
                        EntityUtil.enthrall((LivingEntity)player, living);
                        KnowledgeUtil.grantResearchNoToast((Entity)player, DeityLocks.ENTHRALL_UNDEAD);
                    } else {
                        sp.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237115_((String)"eidolon.title.no_mana")));
                    }
                });
            }
        }
    }
}

