/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.tile;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import elucent.eidolon.client.ClientRegistry;
import elucent.eidolon.common.tile.CrucibleTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class CrucibleTileRenderer
implements BlockEntityRenderer<CrucibleTileEntity> {
    private final ModelPart stirrer = Minecraft.m_91087_().m_167973_().m_171103_(ClientRegistry.CRUCIBLE_STIRRER_LAYER).m_171324_("stirrer");
    public static final ResourceLocation STIRRER_TEXTURE = new ResourceLocation("eidolon", "textures/block/crucible_stirrer.png");

    public static LayerDefinition createModelLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        PartDefinition stirrer = root.m_171599_("stirrer", CubeListBuilder.m_171558_().m_171514_(0, 8).m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-1.0f, 3.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)16, (int)16);
    }

    public void render(CrucibleTileEntity tile, float partialTicks, @NotNull PoseStack matrixStackIn, @NotNull MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        float coeff;
        Minecraft mc = Minecraft.m_91087_();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)STIRRER_TEXTURE);
        float f = coeff = tile.stirTicks == 0 ? 0.0f : ((float)tile.stirTicks - partialTicks) / 20.0f;
        if (!tile.m_58904_().m_8055_(tile.m_58899_().m_7494_()).m_60783_((BlockGetter)tile.m_58904_(), tile.m_58899_().m_7494_(), Direction.DOWN)) {
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(0.5, 0.625, 0.5);
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(45.0f + coeff * 360.0f));
            matrixStackIn.m_85837_(0.0, -0.125 * Math.sin((double)coeff * Math.PI), 0.125);
            this.stirrer.f_104203_ = 0.3926991f * (1.0f - (float)Math.sin((double)coeff * Math.PI));
            this.stirrer.m_104301_(matrixStackIn, bufferIn.m_6299_(RenderType.m_110446_((ResourceLocation)STIRRER_TEXTURE)), combinedLightIn, combinedOverlayIn);
            matrixStackIn.m_85849_();
        }
        if (tile.hasWater) {
            TextureAtlasSprite water = (TextureAtlasSprite)mc.m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("minecraft", "block/water_still"));
            VertexConsumer builder = bufferIn.m_6299_(RenderType.m_110472_());
            Matrix4f mat = matrixStackIn.m_85850_().m_252922_();
            int color = BiomeColors.m_108811_((BlockAndTintGetter)tile.m_58904_(), (BlockPos)tile.m_58899_());
            int r = FastColor.ARGB32.m_13665_((int)color);
            int g = FastColor.ARGB32.m_13667_((int)color);
            int b = FastColor.ARGB32.m_13669_((int)color);
            int a = FastColor.ARGB32.m_13655_((int)color);
            if (tile.steps.size() > 0) {
                r = (int)(tile.getRed() * 255.0f);
                g = (int)(tile.getGreen() * 255.0f);
                b = (int)(tile.getBlue() * 255.0f);
            }
            builder.m_252986_(mat, 0.125f, 0.75f, 0.125f).m_6122_(r, g, b, 192).m_7421_(water.m_118367_(2.0), water.m_118393_(2.0)).m_85969_(combinedLightIn).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            builder.m_252986_(mat, 0.125f, 0.75f, 0.875f).m_6122_(r, g, b, 192).m_7421_(water.m_118367_(14.0), water.m_118393_(2.0)).m_85969_(combinedLightIn).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            builder.m_252986_(mat, 0.875f, 0.75f, 0.875f).m_6122_(r, g, b, 192).m_7421_(water.m_118367_(14.0), water.m_118393_(14.0)).m_85969_(combinedLightIn).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            builder.m_252986_(mat, 0.875f, 0.75f, 0.125f).m_6122_(r, g, b, 192).m_7421_(water.m_118367_(2.0), water.m_118393_(14.0)).m_85969_(combinedLightIn).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        }
    }
}

