/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.gui.jei;

import elucent.eidolon.codex.CruciblePage;
import elucent.eidolon.codex.Page;
import elucent.eidolon.gui.jei.JEIRegistry;
import elucent.eidolon.recipe.CrucibleRecipe;
import elucent.eidolon.registries.Registry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class CrucibleCategory
implements IRecipeCategory<CrucibleRecipe> {
    static final ResourceLocation UID = new ResourceLocation("eidolon", "crucible");
    private final IDrawable background;
    private final IDrawable icon;

    public CrucibleCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(new ResourceLocation("eidolon", "textures/gui/jei_page_bg.png"), 0, 0, 138, 172);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Registry.CRUCIBLE.get()));
    }

    @NotNull
    public RecipeType<CrucibleRecipe> getRecipeType() {
        return JEIRegistry.CRUCIBLE_CATEGORY;
    }

    @NotNull
    public Component getTitle() {
        return Component.m_237115_((String)"jei.eidolon.crucible");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public static void condense(List<StackIngredient> stacks) {
        Iterator<StackIngredient> iter = stacks.iterator();
        StackIngredient last = new StackIngredient(ItemStack.f_41583_, Ingredient.f_43901_);
        while (iter.hasNext()) {
            StackIngredient i = iter.next();
            if (!ItemStack.m_41656_((ItemStack)i.stack, (ItemStack)last.stack) || !ItemStack.m_150942_((ItemStack)i.stack, (ItemStack)last.stack) || last.stack.m_41613_() + i.stack.m_41613_() > last.stack.m_41741_()) {
                last = i;
                continue;
            }
            last.stack.m_41769_(i.stack.m_41613_());
            iter.remove();
        }
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder layout, CrucibleRecipe recipe, @NotNull IFocusGroup focusGroup) {
        List<CrucibleRecipe.Step> steps = recipe.getSteps();
        int h = steps.size() * 20 + 32;
        int yoff = 80 - h / 2;
        for (int i = 0; i < steps.size(); ++i) {
            int tx = 4;
            int ty = 3 + yoff + i * 20;
            tx += 24;
            ArrayList<StackIngredient> stepInputs = new ArrayList<StackIngredient>();
            for (Ingredient o : steps.get((int)i).matches) {
                ItemStack stack = o.m_43908_().length > 0 ? o.m_43908_()[0].m_41777_() : ItemStack.f_41583_.m_41777_();
                if (stack.m_41619_()) continue;
                stepInputs.add(new StackIngredient(stack, o));
            }
            CrucibleCategory.condense(stepInputs);
            for (StackIngredient stepInput : stepInputs) {
                List<ItemStack> inputs = Arrays.stream(stepInput.ingredient.m_43908_()).map(ItemStack::m_41777_).toList();
                inputs.forEach(ii -> ii.m_41764_(stepInput.stack.m_41613_()));
                layout.addSlot(RecipeIngredientRole.INPUT, tx, ty).addItemStacks(inputs);
                tx += 17;
            }
        }
        layout.addSlot(RecipeIngredientRole.OUTPUT, 60, yoff + steps.size() * 20 + 14).addItemStack(recipe.getResultItem());
    }

    public void draw(CrucibleRecipe recipe, @NotNull IRecipeSlotsView slotsView, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        int ty;
        List<CrucibleRecipe.Step> steps = recipe.getSteps();
        int h = steps.size() * 20 + 32;
        int yoff = 80 - h / 2;
        int x = 4;
        int y = 5;
        for (int i = 0; i < steps.size(); ++i) {
            int tx = x;
            ty = y + yoff + i * 20;
            guiGraphics.m_280218_(CruciblePage.BACKGROUND, tx, ty, 128, 0, 128, 20);
            tx += 24;
            ArrayList<StackIngredient> stepInputs = new ArrayList<StackIngredient>();
            for (Ingredient o : steps.get((int)i).matches) {
                ItemStack stack = o.m_43908_().length > 0 ? o.m_43908_()[0].m_41777_() : ItemStack.f_41583_.m_41777_();
                if (stack.m_41619_()) continue;
                stepInputs.add(new StackIngredient(stack, o));
            }
            CrucibleCategory.condense(stepInputs);
            for (StackIngredient counter : stepInputs) {
                if (counter.stack.m_41619_()) continue;
                guiGraphics.m_280218_(CruciblePage.BACKGROUND, tx, ty + 1, 176, 32, 16, 17);
                tx += 17;
            }
            for (int j = 0; j < steps.get((int)i).stirs; ++j) {
                guiGraphics.m_280218_(CruciblePage.BACKGROUND, tx, ty + 1, 192, 32, 16, 17);
                tx += 17;
            }
        }
        guiGraphics.m_280218_(CruciblePage.BACKGROUND, x, y + yoff + steps.size() * 20, 128, 64, 128, 32);
        Font font = Minecraft.m_91087_().f_91062_;
        for (int i = 0; i < steps.size(); ++i) {
            ty = y + yoff + i * 20;
            String string = I18n.m_118938_((String)("enchantment.level." + (i + 1)), (Object[])new Object[0]) + ".";
            Objects.requireNonNull(font);
            Page.drawText(guiGraphics, string, x + 7, ty + 17 - 9);
        }
    }

    public static class StackIngredient {
        final ItemStack stack;
        final Ingredient ingredient;

        public StackIngredient(ItemStack stack, Ingredient ingredient) {
            this.stack = stack;
            this.ingredient = ingredient;
        }
    }
}

