/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.network;

import elucent.eidolon.Eidolon;
import elucent.eidolon.capability.IKnowledge;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class KnowledgeUpdatePacket {
    final UUID uuid;
    CompoundTag tag;
    final boolean playSound;

    public KnowledgeUpdatePacket(UUID uuid, CompoundTag tag, boolean playSound) {
        this.uuid = uuid;
        this.tag = tag;
        this.playSound = playSound;
    }

    public KnowledgeUpdatePacket(Player entity, boolean playSound) {
        this.uuid = entity.m_20148_();
        entity.getCapability(IKnowledge.INSTANCE, null).ifPresent(k -> {
            this.tag = (CompoundTag)((INBTSerializable)k).serializeNBT();
        });
        this.playSound = playSound;
    }

    public static void encode(KnowledgeUpdatePacket object, FriendlyByteBuf buffer) {
        buffer.m_130077_(object.uuid);
        buffer.m_130079_(object.tag);
        buffer.writeBoolean(object.playSound);
    }

    public static KnowledgeUpdatePacket decode(FriendlyByteBuf buffer) {
        return new KnowledgeUpdatePacket(buffer.m_130259_(), buffer.m_130260_(), buffer.readBoolean());
    }

    public static void consume(KnowledgeUpdatePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            assert (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT);
            Level world = Eidolon.proxy.getWorld();
            Player player = world.m_46003_(packet.uuid);
            if (player != null) {
                player.getCapability(IKnowledge.INSTANCE, null).ifPresent(k -> {
                    ((INBTSerializable)k).deserializeNBT((Tag)packet.tag);
                    if (packet.playSound) {
                        player.m_5496_(SoundEvents.f_12275_, 1.0f, 0.5f);
                    }
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

