/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import elucent.eidolon.api.ritual.Ritual;
import elucent.eidolon.common.ritual.SummonRitual;
import elucent.eidolon.recipe.RitualRecipe;
import elucent.eidolon.registries.EidolonRecipes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SummonRitualRecipe
extends RitualRecipe {
    ResourceLocation entity;
    int count;

    public SummonRitualRecipe(ResourceLocation id, ResourceLocation result, Ingredient reagent, List<Ingredient> pedestalItems, List<Ingredient> focusItems, int count, float healthRequirement) {
        super(id, reagent, pedestalItems, focusItems, healthRequirement);
        this.entity = result;
        this.count = count;
    }

    public SummonRitualRecipe(ResourceLocation result, Ingredient reagent, List<Ingredient> pedestalItems, List<Ingredient> focusItems, int count, float healthRequirement) {
        this(new ResourceLocation(result.m_135827_(), "summon_" + result.m_135815_()), result, reagent, pedestalItems, focusItems, count, healthRequirement);
    }

    @Override
    public JsonElement asRecipe() {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("type", "eidolon:ritual_brazier_summoning");
        SummonRitualRecipe.addRitualElements(this, jsonobject);
        JsonObject resultObj = new JsonObject();
        resultObj.addProperty("entity", this.entity.toString());
        if (this.count > 1) {
            resultObj.addProperty("count", (Number)this.count);
        }
        jsonobject.add("output", (JsonElement)resultObj);
        return jsonobject;
    }

    public SummonRitualRecipe(ResourceLocation id, ResourceLocation result, Ingredient reagent, List<Ingredient> pedestalItems, List<Ingredient> focusItems) {
        super(id, reagent, pedestalItems, focusItems);
        this.entity = result;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)EidolonRecipes.SUMMON_RITUAL_RECIPE.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)EidolonRecipes.SUMMON_RITUAL_TYPE.get();
    }

    @Override
    public Ritual getRitual() {
        return new SummonRitual((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(this.entity), this.count).setRegistryName(this.id);
    }

    public static class Serializer
    extends RitualRecipe.Serializer<SummonRitualRecipe> {
        @NotNull
        public SummonRitualRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            Ingredient reagent = Ingredient.m_43917_((JsonElement)GsonHelper.m_13933_((JsonObject)json, (String)"reagent"));
            float healthRequirement = json.has("healthRequirement") ? GsonHelper.m_13915_((JsonObject)json, (String)"healthRequirement") : 0.0f;
            JsonArray pedestalItems = GsonHelper.m_13933_((JsonObject)json, (String)"pedestalItems");
            List<Ingredient> stacks = RitualRecipe.getPedestalItems(pedestalItems);
            JsonArray focusItems = GsonHelper.m_13933_((JsonObject)json, (String)"focusItems");
            List<Ingredient> foci = RitualRecipe.getPedestalItems(focusItems);
            JsonObject resultObj = GsonHelper.m_13930_((JsonObject)json, (String)"output");
            ResourceLocation entity = new ResourceLocation(GsonHelper.m_13906_((JsonObject)resultObj, (String)"entity"));
            int count = resultObj.has("count") ? GsonHelper.m_13927_((JsonObject)resultObj, (String)"count") : 1;
            return new SummonRitualRecipe(recipeId, entity, reagent, stacks, foci, count, healthRequirement);
        }

        @Nullable
        public SummonRitualRecipe fromNetwork(@NotNull ResourceLocation pRecipeId, @NotNull FriendlyByteBuf pBuffer) {
            int length = pBuffer.readInt();
            int length2 = pBuffer.readInt();
            Ingredient reagent = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            ArrayList<Ingredient> stacks = new ArrayList<Ingredient>();
            for (int i = 0; i < length; ++i) {
                try {
                    stacks.add(Ingredient.m_43940_((FriendlyByteBuf)pBuffer));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
            ArrayList<Ingredient> foci = new ArrayList<Ingredient>();
            for (int i = 0; i < length2; ++i) {
                try {
                    foci.add(Ingredient.m_43940_((FriendlyByteBuf)pBuffer));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
            float healthRequirement = pBuffer.readFloat();
            ResourceLocation entity = pBuffer.m_130281_();
            int count = pBuffer.readInt();
            return new SummonRitualRecipe(pRecipeId, entity, reagent, stacks, foci, count, healthRequirement);
        }

        @Override
        public void toNetwork(@NotNull FriendlyByteBuf pBuffer, @NotNull SummonRitualRecipe pRecipe) {
            super.toNetwork(pBuffer, pRecipe);
            pBuffer.m_130085_(pRecipe.entity);
            pBuffer.writeInt(pRecipe.count);
        }
    }
}

