/*
 * Decompiled with CFR 0.152.
 */
package artifacts.mixin.item.wearable.aquadashers;

import artifacts.component.SwimData;
import artifacts.platform.PlatformServices;
import artifacts.registry.ModGameRules;
import artifacts.registry.ModItems;
import artifacts.registry.ModSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Shadow
    private Level f_19853_;
    @Shadow
    @Final
    protected RandomSource f_19796_;
    @Shadow
    private EntityDimensions f_19815_;

    @Shadow
    public abstract double m_20185_();

    @Shadow
    public abstract double m_20186_();

    @Shadow
    public abstract double m_20189_();

    @Shadow
    public abstract Vec3 m_20184_();

    @Inject(method={"playStepSound"}, at={@At(value="HEAD")})
    private void playWaterStepSound(BlockPos pos, BlockState blockState, CallbackInfo callbackInfo) {
        if (blockState.m_278721_() && this.isRunningWithAquaDashers()) {
            ((LivingEntity)this).m_5496_(ModSoundEvents.WATER_STEP.get(), 0.15f, 1.0f);
        }
    }

    @Inject(method={"spawnSprintParticle"}, at={@At(value="HEAD")})
    private void spawnWaterSprintParticle(CallbackInfo callbackInfo) {
        BlockPos pos;
        BlockState blockstate;
        if (this.isRunningWithAquaDashers() && (blockstate = this.f_19853_.m_8055_(pos = new BlockPos(Mth.m_14107_((double)this.m_20185_()), Mth.m_14107_((double)(this.m_20186_() - 0.2)), Mth.m_14107_((double)this.m_20189_())))).m_60799_() == RenderShape.INVISIBLE) {
            SimpleParticleType particle;
            Vec3 motion = this.m_20184_().m_82542_(-4.0, 0.0, -4.0);
            if (blockstate.m_60819_().m_205070_(FluidTags.f_13132_)) {
                motion = motion.m_82520_(0.0, 1.0, 0.0);
                if (this.f_19796_.m_188503_(3) == 0) {
                    particle = ParticleTypes.f_123756_;
                } else {
                    particle = ParticleTypes.f_123744_;
                    motion = motion.m_82542_(0.2, 0.03, 0.2);
                }
            } else if (!blockstate.m_60819_().m_76178_()) {
                if (this.f_19796_.m_188503_(3) == 0) {
                    particle = ParticleTypes.f_123795_;
                } else {
                    particle = ParticleTypes.f_123769_;
                    motion = motion.m_82520_(0.0, 1.5, 0.0);
                }
            } else {
                return;
            }
            this.f_19853_.m_7106_((ParticleOptions)particle, this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.f_19815_.f_20377_, this.m_20186_(), this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.f_19815_.f_20377_, motion.f_82479_, motion.f_82480_, motion.f_82481_);
        }
    }

    @Unique
    private boolean isRunningWithAquaDashers() {
        EntityMixin entityMixin = this;
        if (!(entityMixin instanceof LivingEntity)) {
            return false;
        }
        LivingEntity entity = (LivingEntity)entityMixin;
        SwimData swimData = PlatformServices.platformHelper.getSwimData(entity);
        return swimData != null && ModItems.AQUA_DASHERS.get().isEquippedBy(entity) && ModGameRules.AQUA_DASHERS_ENABLED.get() != false && entity.m_20142_() && !swimData.isWet();
    }
}

