/*
 * Decompiled with CFR 0.152.
 */
package com.mystchonky.arsocultas.datagen.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;

public class RecipeUtil {
    protected static void conditionalRecipe(ICondition condition, BiConsumer<Consumer<FinishedRecipe>, ResourceLocation> recipeBuilder, Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        ConditionalRecipe.builder().addCondition(condition).addRecipe(callable -> recipeBuilder.accept((Consumer<FinishedRecipe>)callable, id)).build(consumer, id);
    }

    protected static void modCompatRecipe(String modid, BiConsumer<Consumer<FinishedRecipe>, ResourceLocation> recipeBuilder, Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        RecipeUtil.conditionalRecipe((ICondition)new ModLoadedCondition(modid), recipeBuilder, consumer, id);
    }

    protected static JsonObject modCompatGlyphRecipe(String modid, JsonElement recipe) {
        JsonObject json = new JsonObject();
        JsonArray conds = new JsonArray();
        conds.add((JsonElement)CraftingHelper.serialize((ICondition)new ModLoadedCondition(modid)));
        json.add("conditions", (JsonElement)conds);
        recipe.getAsJsonObject().entrySet().stream().forEach(entry -> json.add((String)entry.getKey(), (JsonElement)entry.getValue()));
        return json;
    }
}

