/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.alftools;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nonnull;
import mythicbotany.MythicBotany;
import mythicbotany.config.MythicConfig;
import mythicbotany.network.AlfSwordLeftClickMessage;
import mythicbotany.pylon.PylonRepairable;
import mythicbotany.register.ModItems;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.common.entity.ManaBurstEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.item.equipment.tool.terrasteel.TerraBladeItem;
import vazkii.botania.common.lib.BotaniaTags;

public class AlfsteelSword
extends TerraBladeItem
implements PylonRepairable {
    private final Multimap<Attribute, AttributeModifier> attributeModifiers;

    public AlfsteelSword(Item.Properties props) {
        super(props.m_41503_(MythicConfig.alftools.durability.sword.max_durability()));
        MinecraftForge.EVENT_BUS.addListener(this::onLeftClick);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.m_43299_(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", MythicConfig.alftools.tool_values.sword_speed, AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
    }

    private void onLeftClick(PlayerInteractEvent.LeftClickEmpty evt) {
        if (!evt.getItemStack().m_41619_() && evt.getItemStack().m_41720_() == this) {
            MythicBotany.getNetwork().channel.sendToServer((Object)new AlfSwordLeftClickMessage());
        }
    }

    public int getManaPerDamage() {
        return 2 * super.getManaPerDamage();
    }

    public float m_43299_() {
        return (float)MythicConfig.alftools.tool_values.sword_damage;
    }

    @Nonnull
    public Multimap<Attribute, AttributeModifier> m_7167_(@Nonnull EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.attributeModifiers : super.m_7167_(equipmentSlot);
    }

    public boolean m_6832_(@Nonnull ItemStack toRepair, @Nonnull ItemStack repair) {
        return repair.m_41720_() == ModItems.alfsteelIngot || !Ingredient.m_204132_((TagKey)BotaniaTags.Items.INGOTS_TERRASTEEL).test(repair) && super.m_6832_(toRepair, repair);
    }

    @Override
    public int getRepairManaPerTick(ItemStack stack) {
        return (int)(2.5 * (double)this.getManaPerDamage());
    }

    @Override
    public ItemStack repairOneTick(ItemStack stack) {
        stack.m_41721_(Math.max(0, stack.m_41773_() - 5));
        return stack;
    }

    public ManaBurstEntity getAlfBurst(Player player, ItemStack stack) {
        ManaBurstEntity burst = TerraBladeItem.getBurst((Player)player, (ItemStack)stack);
        burst.setColor(16224512);
        burst.setMana(this.getManaPerDamage());
        burst.setStartingMana(this.getManaPerDamage());
        burst.setMinManaLoss(20);
        burst.setManaLossPerTick(2.0f);
        return burst;
    }

    public void trySpawnAlfBurst(Player player) {
        if (player.m_6844_(EquipmentSlot.MAINHAND).m_41720_() == ModItems.alfsteelSword && player.m_36403_(0.0f) == 1.0f) {
            ManaBurstEntity burst = this.getAlfBurst(player, player.m_21205_());
            player.m_9236_().m_7967_((Entity)burst);
            player.m_21205_().m_41622_(1, (LivingEntity)player, p -> p.m_21190_(InteractionHand.MAIN_HAND));
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), BotaniaSounds.terraBlade, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public void updateBurst(ManaBurst burst, ItemStack stack) {
        ThrowableProjectile entity = burst.entity();
        AABB aabb = new AABB(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), entity.f_19790_, entity.f_19791_, entity.f_19792_).m_82400_(1.0);
        Entity thrower = entity.m_19749_();
        List entities = entity.m_9236_().m_45976_(LivingEntity.class, aabb);
        for (LivingEntity living : entities) {
            int mana;
            if (living == thrower) continue;
            if (living instanceof Player) {
                Player throwingPlayer;
                Player livingPlayer = (Player)living;
                if (thrower instanceof Player && !(throwingPlayer = (Player)thrower).m_7099_(livingPlayer)) continue;
            }
            if (living.f_20916_ != 0 || (mana = burst.getMana()) < 33) continue;
            burst.setMana(mana - 33);
            float damage = 4.0f + this.m_43299_();
            if (burst.isFake() || entity.m_9236_().f_46443_) continue;
            DamageSource source = entity.m_9236_().m_269111_().m_269425_();
            if (thrower instanceof Player) {
                Player player = (Player)thrower;
                source = entity.m_9236_().m_269111_().m_269075_(player);
            } else if (thrower instanceof LivingEntity) {
                LivingEntity livingThrower = (LivingEntity)thrower;
                source = entity.m_9236_().m_269111_().m_269333_(livingThrower);
            }
            living.m_6469_(source, damage);
            if (burst.getMana() > 0) continue;
            entity.m_146870_();
        }
    }
}

