/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.despawntimers;

import net.minecraft.world.entity.Mob;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="despawntimers")
public class MobDespawnTimers {
    public static final String MODID = "despawntimers";
    public static final Logger LOGGER = LogManager.getLogger((String)"despawntimers");

    public MobDespawnTimers() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SPEC);
    }

    @SubscribeEvent
    public void onDespawn(MobSpawnEvent.AllowDespawn e) {
        Mob ent = e.getEntity();
        if (Config.getDespawnDelay() >= (long)ent.f_19797_) {
            e.setResult(Event.Result.DENY);
        }
    }

    public static class Config {
        public static final ForgeConfigSpec SPEC;
        public static final Config INSTANCE;
        public final ForgeConfigSpec.LongValue despawnDelay;

        public Config(ForgeConfigSpec.Builder b) {
            this.despawnDelay = b.comment("The time, in ticks, that a mob may not despawn for after spawning.").defineInRange("despawn_delay", 600L, 0L, Long.MAX_VALUE);
        }

        public static long getDespawnDelay() {
            return (Long)Config.INSTANCE.despawnDelay.get();
        }

        static {
            Pair specPair = new ForgeConfigSpec.Builder().configure(Config::new);
            SPEC = (ForgeConfigSpec)specPair.getRight();
            INSTANCE = (Config)specPair.getLeft();
        }
    }
}

