/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases.module.chemical;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import mcjty.lib.gui.ITranslatableEnum;
import mcjty.lib.varia.ComponentFactory;
import mcjty.xnet.utils.I18nUtils;

public class ChemicalEnums {

    public static enum Type implements ITranslatableEnum<Type>
    {
        GAS("xnet-gases.gas"),
        INFUSE("xnet-gases.infuse"),
        PIGMENT("xnet-gases.pigment"),
        SLURRY("xnet-gases.slurry");

        private final String i18n;
        public static final Map<String, Type> NAME_MAP;

        private Type(String i18n) {
            this.i18n = i18n;
        }

        public static Type byName(String name) {
            return NAME_MAP.get(name.toUpperCase(Locale.ROOT));
        }

        public String getI18n() {
            return ComponentFactory.translatable((String)this.i18n).getString();
        }

        public String[] getI18nSplitedTooltip() {
            return I18nUtils.getSplitedEnumTooltip((String)this.i18n);
        }

        public static Type safeChemicalType(Object o) {
            if (o != null) {
                return Type.values()[(Integer)o];
            }
            return GAS;
        }

        static {
            NAME_MAP = Arrays.stream(Type.values()).collect(Collectors.toMap(Enum::name, Function.identity()));
        }
    }
}

