/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases.module.chemical.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.pigment.IPigmentHandler;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.core.Direction;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class PigmentHelper {
    @Nonnull
    public static Optional<IPigmentHandler> handler(@Nullable ICapabilityProvider provider, @Nullable Direction direction) {
        if (provider == null) {
            return Optional.empty();
        }
        if (Capabilities.PIGMENT_HANDLER != null && provider.getCapability(Capabilities.PIGMENT_HANDLER, direction).isPresent()) {
            return Optional.of((IPigmentHandler)provider.getCapability(Capabilities.PIGMENT_HANDLER, direction).orElseThrow(() -> new IllegalArgumentException("IPigmentHandler is 'null' even though it said that its present")));
        }
        if (direction != null && provider instanceof IPigmentHandler.ISidedPigmentHandler && ((IPigmentHandler.ISidedPigmentHandler)provider).getTanks(direction) >= 1) {
            return Optional.of((IPigmentHandler)provider);
        }
        if (!(provider instanceof IPigmentHandler.ISidedPigmentHandler) && provider instanceof IPigmentHandler && ((IPigmentHandler)provider).getTanks() >= 1) {
            return Optional.of((IPigmentHandler)provider);
        }
        return Optional.empty();
    }

    @Nonnull
    public static PigmentStack insert(IPigmentHandler handler, PigmentStack stack, @Nullable Direction direction, Action action) {
        if (handler instanceof IPigmentHandler.ISidedPigmentHandler) {
            return (PigmentStack)((IPigmentHandler.ISidedPigmentHandler)handler).insertChemical((ChemicalStack)stack, direction, action);
        }
        return (PigmentStack)handler.insertChemical((ChemicalStack)stack, action);
    }

    @Nonnull
    public static PigmentStack extract(IPigmentHandler handler, long amount, @Nullable Direction direction, Action action) {
        if (handler instanceof IPigmentHandler.ISidedPigmentHandler) {
            return (PigmentStack)((IPigmentHandler.ISidedPigmentHandler)handler).extractChemical(amount, direction, action);
        }
        return (PigmentStack)handler.extractChemical(amount, action);
    }

    public static List<Pigment> chemicalInTank(@Nonnull IPigmentHandler handler, @Nullable Direction direction) {
        ArrayList<Pigment> pigments = new ArrayList<Pigment>();
        if (handler instanceof IPigmentHandler.ISidedPigmentHandler) {
            for (int i = 0; i < ((IPigmentHandler.ISidedPigmentHandler)handler).getTanks(direction); ++i) {
                Pigment pigment = (Pigment)((PigmentStack)((IPigmentHandler.ISidedPigmentHandler)handler).getChemicalInTank(i, direction)).getType();
                if (pigment.isEmptyType()) continue;
                pigments.add(pigment);
            }
        } else {
            for (int i = 0; i < handler.getTanks(); ++i) {
                Pigment pigment = (Pigment)((PigmentStack)handler.getChemicalInTank(i)).getType();
                if (pigment.isEmptyType()) continue;
                pigments.add(pigment);
            }
        }
        return pigments;
    }

    public static List<Pigment> chemicalInTank(@Nonnull IPigmentHandler handler) {
        return PigmentHelper.chemicalInTank(handler, null);
    }

    public static long amountInTank(@Nonnull IPigmentHandler handler, @Nullable Direction direction, @Nullable Predicate<PigmentStack> filter) {
        long count = 0L;
        if (handler instanceof IPigmentHandler.ISidedPigmentHandler) {
            for (int i = 0; i < ((IPigmentHandler.ISidedPigmentHandler)handler).getTanks(direction); ++i) {
                PigmentStack stack = (PigmentStack)((IPigmentHandler.ISidedPigmentHandler)handler).getChemicalInTank(i, direction);
                if (stack.isEmpty() || filter != null && !filter.test(stack)) continue;
                count += stack.getAmount();
            }
        } else {
            for (int i = 0; i < handler.getTanks(); ++i) {
                PigmentStack stack = (PigmentStack)handler.getChemicalInTank(i);
                if (stack.isEmpty() || filter != null && !filter.test(stack)) continue;
                count += stack.getAmount();
            }
        }
        return count;
    }

    public static long amountInTank(@Nonnull IPigmentHandler handler, @Nullable Direction direction, @Nullable Pigment filter) {
        return PigmentHelper.amountInTank(handler, direction, (PigmentStack stack) -> filter == null || stack.getType() == filter);
    }

    public static long amountInTank(@Nonnull IPigmentHandler handler, @Nullable Direction direction, @Nullable PigmentStack filter) {
        return PigmentHelper.amountInTank(handler, direction, (PigmentStack stack) -> filter == null || stack.isTypeEqual((ChemicalStack)filter));
    }

    public static long amountInTank(@Nonnull IPigmentHandler handler, @Nullable Direction direction) {
        return PigmentHelper.amountInTank(handler, direction, (Predicate<PigmentStack>)null);
    }

    public static long amountInTank(@Nonnull IPigmentHandler handler) {
        return PigmentHelper.amountInTank(handler, null);
    }
}

