/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.blocks;

import com.dannyandson.tinyredstone.gui.ChopperItemHandler;
import com.dannyandson.tinyredstone.gui.ChopperMenu;
import com.dannyandson.tinyredstone.setup.Registration;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class ChopperBlockEntity
extends RandomizableContainerBlockEntity {
    private NonNullList<ItemStack> items;
    private ResultContainer resultContainer = new ResultContainer();
    private ChopperMenu chopperMenu;
    private final ChopperItemHandler itemHandler = this.createHandler();
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);
    private String itemType = "Tiny Block";

    public ChopperBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.CUTTER_BLOCK_ENTITY.get(), pos, state);
        this.items = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
    }

    public void setCutterMenu(ChopperMenu chopperMenu) {
        this.chopperMenu = chopperMenu;
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.chopperMenu != null) {
            this.chopperMenu.m_6199_((Container)this);
        }
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"block.tinyredstone.block_chopper");
    }

    protected AbstractContainerMenu m_6555_(int containerId, Inventory playerInventory) {
        return ChopperMenu.createChopperMenu(containerId, playerInventory, (Container)this);
    }

    public int m_6643_() {
        return 1;
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    protected void m_6520_(NonNullList<ItemStack> items) {
        this.items = items;
    }

    public ResultContainer getResultContainer() {
        return this.resultContainer;
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        this.items.set(0, (Object)ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("input_container")));
        this.resultContainer.m_6836_(0, ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("output_container")));
        this.itemType = compoundTag.m_128461_("output_type");
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        compoundTag.m_128365_("input_container", (Tag)((ItemStack)this.items.get(0)).serializeNBT());
        compoundTag.m_128365_("output_container", (Tag)this.resultContainer.m_8020_(0).serializeNBT());
        compoundTag.m_128359_("output_type", this.itemType);
    }

    private ChopperItemHandler createHandler() {
        return new ChopperItemHandler(this);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_7651_() {
        super.m_7651_();
        this.handler.invalidate();
    }

    public String getItemType() {
        return this.itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
        if (this.chopperMenu != null) {
            this.chopperMenu.m_6199_(null);
        }
    }
}

