/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.blocks.panelcells;

import com.dannyandson.tinyredstone.api.IObservingPanelCell;
import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.RenderHelper;
import com.dannyandson.tinyredstone.blocks.Side;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.LinkedList;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public class Observer
implements IPanelCell,
IObservingPanelCell {
    public static ResourceLocation TEXTURE_OBSERVER_TOP = new ResourceLocation("minecraft", "block/observer_top");
    public static ResourceLocation TEXTURE_OBSERVER_BACK_ON = new ResourceLocation("minecraft", "block/observer_back_on");
    public static ResourceLocation TEXTURE_OBSERVER_BACK = new ResourceLocation("minecraft", "block/observer_back");
    public static ResourceLocation TEXTURE_OBSERVER_FRONT = new ResourceLocation("minecraft", "block/observer_front");
    public static ResourceLocation TEXTURE_OBSERVER_SIDE = new ResourceLocation("minecraft", "block/observer_side");
    boolean output = false;
    private LinkedList<Boolean> queue = new LinkedList();
    private int changedTick = -1;

    @Override
    public void render(PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, float alpha) {
        VertexConsumer builder = buffer.m_6299_((double)alpha == 1.0 ? RenderType.m_110451_() : RenderType.m_110466_());
        TextureAtlasSprite sprite_top = RenderHelper.getSprite(TEXTURE_OBSERVER_TOP);
        TextureAtlasSprite sprite_back = this.output ? RenderHelper.getSprite(TEXTURE_OBSERVER_BACK_ON) : RenderHelper.getSprite(TEXTURE_OBSERVER_BACK);
        TextureAtlasSprite sprite_front = RenderHelper.getSprite(TEXTURE_OBSERVER_FRONT);
        TextureAtlasSprite sprite_side = RenderHelper.getSprite(TEXTURE_OBSERVER_SIDE);
        matrixStack.m_252880_(0.0f, 0.0f, 1.0f);
        this.addRectangle(builder, matrixStack, sprite_top, combinedLight, alpha);
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
        matrixStack.m_252880_(0.0f, 0.0f, 1.0f);
        this.addRectangle(builder, matrixStack, sprite_front, combinedLight, alpha);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        matrixStack.m_252880_(0.0f, 0.0f, 1.0f);
        this.addRectangle(builder, matrixStack, sprite_side, combinedLight, alpha);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        matrixStack.m_252880_(0.0f, 0.0f, 1.0f);
        this.addRectangle(builder, matrixStack, sprite_back, combinedLight, alpha);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        matrixStack.m_252880_(0.0f, 0.0f, 1.0f);
        this.addRectangle(builder, matrixStack, sprite_side, combinedLight, alpha);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
        matrixStack.m_252880_(-1.0f, 0.0f, 1.0f);
        this.addRectangle(builder, matrixStack, sprite_top, combinedLight, alpha);
    }

    private void addRectangle(VertexConsumer builder, PoseStack matrixStack, TextureAtlasSprite sprite, int combinedLight, float alpha) {
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite, combinedLight, alpha);
    }

    @Override
    public boolean neighborChanged(PanelCellPos cellPos) {
        return false;
    }

    @Override
    public int getWeakRsOutput(Side outputDirection) {
        return outputDirection == Side.BACK && this.output ? 15 : 0;
    }

    @Override
    public int getStrongRsOutput(Side outputDirection) {
        return this.getWeakRsOutput(outputDirection);
    }

    @Override
    public boolean isIndependentState() {
        return true;
    }

    @Override
    public boolean isPushable() {
        return true;
    }

    @Override
    public boolean canPlaceVertical() {
        return true;
    }

    @Override
    public boolean tick(PanelCellPos cellPos) {
        if (this.changedTick > -1 && this.changedTick < cellPos.getPanelTile().getRelTickTime()) {
            this.frontNeighborUpdated();
            this.changedTick = -1;
        }
        boolean change = false;
        if (this.queue.size() > 0) {
            change = this.setOutput(this.queue.remove());
        } else if (this.output) {
            this.output = false;
            change = true;
        }
        if (this.changedTick > -1) {
            this.frontNeighborUpdated();
            this.changedTick = -1;
        }
        return change;
    }

    private boolean setOutput(boolean output) {
        if (this.output != output) {
            this.output = output;
            return true;
        }
        return false;
    }

    @Override
    public CompoundTag writeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("output", this.output);
        Object queueString = "";
        boolean i = false;
        for (Object b : this.queue.toArray()) {
            queueString = (String)queueString + ((Boolean)b != false ? "1" : "0");
        }
        nbt.m_128359_("queue", (String)queueString);
        nbt.m_128405_("changedTick", this.changedTick);
        return nbt;
    }

    @Override
    public void readNBT(CompoundTag compoundNBT) {
        this.output = compoundNBT.m_128471_("output");
        String queueString = compoundNBT.m_128461_("queue");
        byte[] byArray = queueString.getBytes();
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            Byte b = byArray[i];
            this.queue.add(b == 49);
        }
        this.changedTick = compoundNBT.m_128451_("changedTick");
    }

    @Override
    public boolean frontNeighborUpdated(PanelCellPos cellPos) {
        this.changedTick = cellPos.getPanelTile().getRelTickTime();
        return false;
    }

    private void frontNeighborUpdated() {
        if (this.queue.isEmpty()) {
            this.queue.add(false);
            this.queue.add(true);
            this.queue.add(true);
        }
    }
}

