/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.blocks.panelcovers;

import com.dannyandson.tinyredstone.api.IPanelCover;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.RenderHelper;
import com.dannyandson.tinyredstone.blocks.Side;
import com.dannyandson.tinyredstone.setup.Registration;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class DarkCover
implements IPanelCover {
    public static ResourceLocation TEXTURE_DEFAULT_COVER = new ResourceLocation("tinyredstone", "block/dark_cover");
    protected ResourceLocation madeFrom;
    protected TextureAtlasSprite sprite_top;
    protected TextureAtlasSprite sprite_front;
    protected TextureAtlasSprite sprite_right;
    protected TextureAtlasSprite sprite_back;
    protected TextureAtlasSprite sprite_left;
    protected TextureAtlasSprite sprite_bottom;
    private float x1 = 0.0f;
    private float x2 = 1.0f;
    private float y1 = 0.0f;
    private float y2 = 1.0f;

    @Override
    public void render(PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, int color) {
        if (this.sprite_top == null) {
            if (this.madeFrom != null) {
                this.sprite_top = Registration.TINY_BLOCK_OVERRIDES.getSprite(this.madeFrom, Side.TOP);
                this.sprite_front = Registration.TINY_BLOCK_OVERRIDES.getSprite(this.madeFrom, Side.FRONT);
                this.sprite_right = Registration.TINY_BLOCK_OVERRIDES.getSprite(this.madeFrom, Side.RIGHT);
                this.sprite_back = Registration.TINY_BLOCK_OVERRIDES.getSprite(this.madeFrom, Side.BACK);
                this.sprite_left = Registration.TINY_BLOCK_OVERRIDES.getSprite(this.madeFrom, Side.LEFT);
                this.sprite_bottom = Registration.TINY_BLOCK_OVERRIDES.getSprite(this.madeFrom, Side.BOTTOM);
            } else {
                this.sprite_left = this.sprite_bottom = RenderHelper.getSprite(this.getDefaultResourceLocation());
                this.sprite_back = this.sprite_bottom;
                this.sprite_right = this.sprite_bottom;
                this.sprite_front = this.sprite_bottom;
                this.sprite_top = this.sprite_bottom;
            }
        }
        TextureAtlasSprite sprite = RenderHelper.getSprite(TEXTURE_DEFAULT_COVER);
        matrixStack.m_252880_(0.0f, this.y2, 1.0f);
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(270.0f));
        RenderHelper.drawCube(matrixStack, buffer.m_6299_(RenderType.m_110451_()), this.sprite_top, this.sprite_front, this.sprite_right, this.sprite_back, this.sprite_left, this.sprite_bottom, combinedLight, this.madeFrom != null ? 0xFFFFFF : color, 1.0f);
    }

    protected ResourceLocation getDefaultResourceLocation() {
        return TEXTURE_DEFAULT_COVER;
    }

    @Override
    public void onPlace(PanelTile panelTile, Player player) {
        CompoundTag itemNBT;
        CompoundTag madeFromTag;
        ItemStack stack = ItemStack.f_41583_;
        if (player.m_7655_() != null) {
            stack = player.m_21120_(player.m_7655_());
        }
        if (stack == ItemStack.f_41583_) {
            stack = player.m_21205_();
        }
        if (stack.m_41782_() && (madeFromTag = (itemNBT = stack.m_41783_()).m_128469_("made_from")).m_128441_("namespace")) {
            this.madeFrom = new ResourceLocation(madeFromTag.m_128461_("namespace"), madeFromTag.m_128461_("path"));
        }
    }

    @Override
    public boolean allowsLightOutput() {
        return false;
    }

    @Override
    public CompoundTag writeNBT() {
        CompoundTag nbt = new CompoundTag();
        if (this.madeFrom != null) {
            nbt.m_128359_("made_from_namespace", this.madeFrom.m_135827_());
            nbt.m_128359_("made_from_path", this.madeFrom.m_135815_());
        }
        return nbt;
    }

    @Override
    public void readNBT(CompoundTag compoundNBT) {
        if (compoundNBT.m_128441_("made_from_namespace")) {
            this.madeFrom = new ResourceLocation(compoundNBT.m_128461_("made_from_namespace"), compoundNBT.m_128461_("made_from_path"));
        }
    }

    @Override
    public CompoundTag getItemTag() {
        if (this.madeFrom != null) {
            CompoundTag madeFromTag = new CompoundTag();
            madeFromTag.m_128359_("namespace", this.madeFrom.m_135827_());
            madeFromTag.m_128359_("path", this.madeFrom.m_135815_());
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128365_("made_from", (Tag)madeFromTag);
            return itemTag;
        }
        return null;
    }
}

