/*
 * Decompiled with CFR 0.152.
 */
package edivad.extrastorage.setup;

import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationManager;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationSpec;
import edivad.extrastorage.blockentity.AdvancedCrafterBlockEntity;
import edivad.extrastorage.blockentity.AdvancedExporterBlockEntity;
import edivad.extrastorage.blockentity.AdvancedFluidStorageBlockEntity;
import edivad.extrastorage.blockentity.AdvancedImporterBlockEntity;
import edivad.extrastorage.blockentity.AdvancedStorageBlockEntity;
import edivad.extrastorage.blocks.CrafterTier;
import edivad.extrastorage.items.storage.fluid.FluidStorageType;
import edivad.extrastorage.items.storage.item.ItemStorageType;
import edivad.extrastorage.setup.ESBlocks;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ESBlockEntities {
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"extrastorage");
    public static final Map<ItemStorageType, RegistryObject<BlockEntityType<AdvancedStorageBlockEntity>>> ITEM_STORAGE = new HashMap<ItemStorageType, RegistryObject<BlockEntityType<AdvancedStorageBlockEntity>>>();
    public static final Map<FluidStorageType, RegistryObject<BlockEntityType<AdvancedFluidStorageBlockEntity>>> FLUID_STORAGE = new HashMap<FluidStorageType, RegistryObject<BlockEntityType<AdvancedFluidStorageBlockEntity>>>();
    public static final Map<CrafterTier, RegistryObject<BlockEntityType<AdvancedCrafterBlockEntity>>> CRAFTER = new HashMap<CrafterTier, RegistryObject<BlockEntityType<AdvancedCrafterBlockEntity>>>();
    public static final RegistryObject<BlockEntityType<AdvancedExporterBlockEntity>> ADVANCED_EXPORTER = BLOCK_ENTITIES.register("advanced_exporter", () -> ESBlockEntities.registerSynchronizationParameters(AdvancedExporterBlockEntity.SPEC, BlockEntityType.Builder.m_155273_(AdvancedExporterBlockEntity::new, (Block[])new Block[]{(Block)ESBlocks.ADVANCED_EXPORTER.get()}).m_58966_(null)));
    public static final RegistryObject<BlockEntityType<AdvancedImporterBlockEntity>> ADVANCED_IMPORTER = BLOCK_ENTITIES.register("advanced_importer", () -> ESBlockEntities.registerSynchronizationParameters(AdvancedImporterBlockEntity.SPEC, BlockEntityType.Builder.m_155273_(AdvancedImporterBlockEntity::new, (Block[])new Block[]{(Block)ESBlocks.ADVANCED_IMPORTER.get()}).m_58966_(null)));

    private static <T extends BlockEntity> BlockEntityType<T> registerSynchronizationParameters(BlockEntitySynchronizationSpec spec, BlockEntityType<T> t) {
        spec.getParameters().forEach(BlockEntitySynchronizationManager::registerParameter);
        return t;
    }

    public static void register(IEventBus modEventBus) {
        BLOCK_ENTITIES.register(modEventBus);
    }

    private static /* synthetic */ BlockEntityType lambda$static$7(CrafterTier tier) {
        return ESBlockEntities.registerSynchronizationParameters(AdvancedCrafterBlockEntity.SPEC, BlockEntityType.Builder.m_155273_((pos, state) -> new AdvancedCrafterBlockEntity(tier, pos, state), (Block[])new Block[]{(Block)ESBlocks.CRAFTER.get((Object)tier).get()}).m_58966_(null));
    }

    private static /* synthetic */ BlockEntityType lambda$static$5(FluidStorageType type) {
        return ESBlockEntities.registerSynchronizationParameters(AdvancedFluidStorageBlockEntity.SPEC, BlockEntityType.Builder.m_155273_((pos, state) -> new AdvancedFluidStorageBlockEntity(type, pos, state), (Block[])new Block[]{(Block)ESBlocks.FLUID_STORAGE.get((Object)type).get()}).m_58966_(null));
    }

    static {
        for (ItemStorageType itemStorageType : ItemStorageType.values()) {
            ITEM_STORAGE.put(itemStorageType, (RegistryObject<BlockEntityType<AdvancedStorageBlockEntity>>)BLOCK_ENTITIES.register("block_" + itemStorageType.getName(), () -> ESBlockEntities.registerSynchronizationParameters(AdvancedStorageBlockEntity.SPEC, BlockEntityType.Builder.m_155273_((pos, state) -> new AdvancedStorageBlockEntity(itemStorageType, pos, state), (Block[])new Block[]{(Block)ESBlocks.ITEM_STORAGE.get((Object)itemStorageType).get()}).m_58966_(null))));
        }
        for (Enum enum_ : FluidStorageType.values()) {
            FLUID_STORAGE.put((FluidStorageType)enum_, (RegistryObject<BlockEntityType<AdvancedFluidStorageBlockEntity>>)BLOCK_ENTITIES.register("block_" + ((FluidStorageType)enum_).getName() + "_fluid", () -> ESBlockEntities.lambda$static$5((FluidStorageType)enum_)));
        }
        for (Enum enum_ : CrafterTier.values()) {
            CRAFTER.put((CrafterTier)enum_, (RegistryObject<BlockEntityType<AdvancedCrafterBlockEntity>>)BLOCK_ENTITIES.register(((CrafterTier)enum_).getID(), () -> ESBlockEntities.lambda$static$7((CrafterTier)enum_)));
        }
    }
}

