/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.agriculturehusbandry.tile;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile;
import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.block.tile.RangeManager;
import com.buuz135.industrial.config.machine.agriculturehusbandry.AnimalRancherConfig;
import com.buuz135.industrial.module.ModuleAgricultureHusbandry;
import com.buuz135.industrial.utils.ItemStackUtils;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.ItemHandlerHelper;

public class AnimalRancherTile
extends IndustrialAreaWorkingTile<AnimalRancherTile> {
    private int maxProgress;
    private int powerPerOperation;
    @Save
    private SidedFluidTankComponent<AnimalRancherTile> tank = (SidedFluidTankComponent)new SidedFluidTankComponent("fluid_output", AnimalRancherConfig.maxTankSize, 47, 20, 0).setColor(DyeColor.WHITE).setComponentHarness((IComponentHarness)this);
    @Save
    private SidedInventoryComponent<AnimalRancherTile> output;

    public AnimalRancherTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleAgricultureHusbandry.ANIMAL_RANCHER, RangeManager.RangeType.BEHIND, true, AnimalRancherConfig.powerPerOperation, blockPos, blockState);
        this.addTank(this.tank);
        this.output = (SidedInventoryComponent)new SidedInventoryComponent("output", 74, 22, 15, 1).setColor(DyeColor.ORANGE).setRange(5, 3).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.output);
        this.maxProgress = AnimalRancherConfig.maxProgress;
        this.powerPerOperation = AnimalRancherConfig.powerPerOperation;
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        List mobs;
        if (this.hasEnergy(this.powerPerOperation) && (mobs = this.f_58857_.m_45976_(PathfinderMob.class, this.getWorkingArea().m_83215_())).size() > 0) {
            for (PathfinderMob mob : mobs) {
                FakePlayer player = IndustrialForegoing.getFakePlayer(this.f_58857_, mob.m_20183_());
                ItemStack shears = new ItemStack((ItemLike)Items.f_42574_);
                if (mob instanceof IForgeShearable && ((IForgeShearable)mob).isShearable(shears, this.f_58857_, mob.m_20183_())) {
                    List items = ((IForgeShearable)mob).onSheared((Player)player, shears, this.f_58857_, mob.m_20183_(), 0);
                    items.forEach(stack -> ItemHandlerHelper.insertItem(this.output, (ItemStack)stack, (boolean)false));
                    if (items.size() > 0) {
                        return new IndustrialWorkingTile.WorkAction(this, 0.35f, this.powerPerOperation);
                    }
                }
                if (mob instanceof Squid && !ItemStackUtils.isInventoryFull(this.output) && this.f_58857_.f_46441_.m_188499_() && this.f_58857_.f_46441_.m_188499_() && this.f_58857_.f_46441_.m_188499_() && this.f_58857_.f_46441_.m_188499_()) {
                    ItemHandlerHelper.insertItem(this.output, (ItemStack)new ItemStack((ItemLike)Items.f_42498_), (boolean)false);
                    return new IndustrialWorkingTile.WorkAction(this, 0.35f, this.powerPerOperation);
                }
                if (!(mob instanceof Animal) || this.tank.getFluidAmount() + 1000 > this.tank.getCapacity()) continue;
                player.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42446_));
                if (!((Animal)mob).m_6071_((Player)player, InteractionHand.MAIN_HAND).m_19077_()) continue;
                ItemStack stack2 = player.m_21120_(InteractionHand.MAIN_HAND);
                IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)stack2.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse(null);
                if (fluidHandlerItem != null) {
                    this.tank.fillForced(fluidHandlerItem.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                    player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                    return new IndustrialWorkingTile.WorkAction(this, 0.35f, this.powerPerOperation);
                }
                player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
            }
        }
        return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
    }

    protected EnergyStorageComponent<AnimalRancherTile> createEnergyStorage() {
        return new EnergyStorageComponent(AnimalRancherConfig.maxStoredPower, 10, 20);
    }

    @Override
    public int getMaxProgress() {
        return this.maxProgress;
    }

    @Nonnull
    public AnimalRancherTile getSelf() {
        return this;
    }
}

