/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.inventoryessentials;

import java.util.HashSet;
import java.util.Set;
import net.blay09.mods.inventoryessentials.data.IgnoredData;
import net.blay09.mods.inventoryessentials.mixin.AbstractContainerMenuAccessor;
import net.blay09.mods.inventoryessentials.mixin.AbstractContainerScreenAccessor;
import net.blay09.mods.inventoryessentials.mixin.CreativeModeInventoryScreenAccessor;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.Nullable;

public class InventoryEssentialsIgnores {
    private static final Set<String> ignoredScreenClasses = new HashSet<String>();
    private static final Set<String> ignoredMenuClasses = new HashSet<String>();
    private static final Set<String> ignored = new HashSet<String>();
    private static final Set<ResourceLocation> ignoredMenuTypes = new HashSet<ResourceLocation>();

    public static boolean shouldIgnoreScreen(Screen screen) {
        ResourceLocation typeId;
        if (!(screen instanceof AbstractContainerScreenAccessor)) {
            return true;
        }
        if (ignoredScreenClasses.contains(screen.getClass().getName())) {
            return true;
        }
        AbstractContainerMenu menu = ((AbstractContainerScreen)screen).m_6262_();
        if (ignoredMenuClasses.contains(menu.getClass().getName())) {
            return true;
        }
        MenuType<?> menuType = ((AbstractContainerMenuAccessor)menu).balm$getMenuType();
        ResourceLocation resourceLocation = typeId = menuType != null ? BuiltInRegistries.f_256818_.m_7981_(menuType) : null;
        return typeId != null && ignoredMenuTypes.contains(typeId);
    }

    public static boolean shouldIgnoreSlot(AbstractContainerScreen<?> screen, @Nullable Slot slot) {
        if (slot == null) {
            return true;
        }
        if (ignored.contains(slot.getClass().getName())) {
            return true;
        }
        if (slot instanceof ResultSlot) {
            return true;
        }
        if (screen instanceof CreativeModeInventoryScreenAccessor) {
            CreativeModeInventoryScreenAccessor creativeAccessor = (CreativeModeInventoryScreenAccessor)screen;
            return !(slot.f_40218_ instanceof Inventory) && slot.f_40218_ == creativeAccessor.getCONTAINER();
        }
        return false;
    }

    public static void addIgnoredMenuType(ResourceLocation menuId) {
        ignoredMenuTypes.add(menuId);
    }

    public static void addIgnoredMenuClass(String menuClass) {
        ignoredMenuClasses.add(menuClass);
    }

    public static void addIgnoredScreenClass(String screenClass) {
        ignoredScreenClasses.add(screenClass);
    }

    public static void addIgnoredSlotClass(String slotClass) {
        ignored.add(slotClass);
    }

    public static void addIgnoredData(IgnoredData ignoredData) {
        ignoredData.ignoredMenuClasses.forEach(InventoryEssentialsIgnores::addIgnoredMenuClass);
        ignoredData.ignoredMenuTypes.stream().map(ResourceLocation::new).forEach(InventoryEssentialsIgnores::addIgnoredMenuType);
        ignoredData.ignoredScreenClasses.forEach(InventoryEssentialsIgnores::addIgnoredScreenClass);
        ignoredData.ignoredSlotClasses.forEach(InventoryEssentialsIgnores::addIgnoredSlotClass);
    }
}

