/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.blueprints.v1;

import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.client.BlueprintBlockInfoTransformHandler;
import com.ldtteam.structurize.client.BlueprintEntityInfoTransformHandler;
import com.ldtteam.structurize.util.BlockEntityInfo;
import com.ldtteam.structurize.util.BlockInfo;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

public final class BlueprintUtils {
    private BlueprintUtils() {
        throw new IllegalArgumentException("Utils class");
    }

    public static Map<BlockPos, BlockEntity> instantiateTileEntities(Blueprint blueprint, Level beLevel, Map<BlockPos, ModelData> teModelData) {
        return blueprint.getBlockInfoAsList().stream().map(blockInfo -> BlueprintBlockInfoTransformHandler.getInstance().Transform((BlockInfo)blockInfo)).filter(BlockInfo::hasTileEntityData).map(blockInfo -> {
            @Nullable BlockEntity be = BlueprintUtils.constructTileEntity(blockInfo, beLevel);
            if (be != null) {
                teModelData.put(blockInfo.getPos(), be.getModelData());
                return new BlockEntityInfo(blockInfo.getPos(), be);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toMap(BlockEntityInfo::pos, BlockEntityInfo::blockEntity));
    }

    public static List<Entity> instantiateEntities(Blueprint blueprint, Level entityLevel) {
        return blueprint.getEntitiesAsList().stream().map(entityInfo -> BlueprintEntityInfoTransformHandler.getInstance().Transform((CompoundTag)entityInfo)).map(entityInfo -> BlueprintUtils.constructEntity(entityInfo, entityLevel)).filter(Objects::nonNull).toList();
    }

    @Nullable
    public static BlockEntity constructTileEntity(BlockInfo info, Level beLevel) {
        if (info == null || info.getTileEntityData() == null) {
            return null;
        }
        String entityId = info.getTileEntityData().m_128461_("id");
        try {
            CompoundTag compound = info.getTileEntityData().m_6426_();
            compound.m_128405_("x", info.getPos().m_123341_());
            compound.m_128405_("y", info.getPos().m_123342_());
            compound.m_128405_("z", info.getPos().m_123343_());
            BlockState blockState = info.getState();
            BlockEntity entity = BlockEntity.m_155241_((BlockPos)info.getPos(), (BlockState)Objects.requireNonNull(blockState), (CompoundTag)compound);
            if (entity != null) {
                if (!entity.m_58903_().m_155262_(blockState)) {
                    Log.getLogger().error("TileEntity " + entityId + " does not accept blockState: " + String.valueOf(blockState));
                    return null;
                }
                if (beLevel != null) {
                    entity.m_142339_(beLevel);
                }
            }
            return entity;
        }
        catch (Exception ex) {
            Log.getLogger().error("Could not create tile entity: " + entityId + " with nbt: " + info.toString(), (Throwable)ex);
            return null;
        }
    }

    @Nullable
    private static Entity constructEntity(@Nullable CompoundTag info, Level entityLevel) {
        if (info == null) {
            return null;
        }
        String entityId = info.m_128461_("id");
        try {
            Entity entity;
            CompoundTag compound = info.m_6426_();
            compound.m_128362_("UUID", UUID.randomUUID());
            Optional type = EntityType.m_20637_((CompoundTag)compound);
            if (type.isPresent() && (entity = ((EntityType)type.get()).m_20615_(entityLevel)) != null) {
                entity.deserializeNBT(compound);
                entity.m_146867_();
                if (entity instanceof LivingEntity) {
                    LivingEntity lentity = (LivingEntity)entity;
                    lentity.f_20886_ = lentity.f_20885_;
                    lentity.f_20884_ = lentity.f_20883_;
                }
                return entity;
            }
            return null;
        }
        catch (Exception ex) {
            Log.getLogger().error("Could not create entity: " + entityId + " with nbt: " + info.toString(), (Throwable)ex);
            return null;
        }
    }
}

