/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client.fakelevel;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LightLayer;
import net.minecraftforge.common.ForgeConfigSpec;

public interface IFakeLevelLightProvider {
    public static final IFakeLevelLightProvider USE_CLIENT_LEVEL = new IFakeLevelLightProvider(){

        @Override
        public boolean forceOwnLightLevel() {
            return false;
        }

        @Override
        public int getBlockLight(BlockPos pos) {
            throw new UnsupportedOperationException("Noop light provider");
        }

        @Override
        public int getSkyDarken() {
            throw new UnsupportedOperationException("Noop light provider");
        }
    };

    public boolean forceOwnLightLevel();

    public int getBlockLight(BlockPos var1);

    public int getSkyDarken();

    default public long getDayTime() {
        return 6000L;
    }

    default public int getSkyLight(BlockPos pos) {
        return this.getBlockLight(pos);
    }

    default public int getBrightness(LightLayer lightLayer, BlockPos pos) {
        return lightLayer == LightLayer.SKY ? this.getSkyLight(pos) : this.getBlockLight(pos);
    }

    default public int getRawBrightness(BlockPos pos, int skyAmount) {
        int sky = this.getSkyLight(pos) - skyAmount;
        int block = this.getBlockLight(pos);
        return Math.max(block, sky);
    }

    public static class ConfigBasedLightProvider
    implements IFakeLevelLightProvider {
        private final ForgeConfigSpec.IntValue configValue;

        public ConfigBasedLightProvider(ForgeConfigSpec.IntValue configValue) {
            this.configValue = configValue;
        }

        @Override
        public boolean forceOwnLightLevel() {
            int val = (Integer)this.configValue.get();
            return 0 <= val && val <= 15;
        }

        @Override
        public int getBlockLight(BlockPos pos) {
            return (Integer)this.configValue.get();
        }

        @Override
        public int getSkyDarken() {
            return (Integer)this.configValue.get();
        }
    }
}

