/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.blockentities.interfaces.IBlueprintDataProviderBE;
import com.ldtteam.structurize.network.messages.IMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class AddRemoveTagMessage
implements IMessage {
    private boolean add = false;
    private String tag = "";
    private final BlockPos anchorPos;
    private final BlockPos tagPos;

    public AddRemoveTagMessage(FriendlyByteBuf buf) {
        this.add = buf.readBoolean();
        this.tag = buf.m_130136_(Short.MAX_VALUE);
        this.anchorPos = buf.m_130135_();
        this.tagPos = buf.m_130135_();
    }

    public AddRemoveTagMessage(boolean add, String tag, BlockPos tagPos, BlockPos anchorPos) {
        this.anchorPos = anchorPos;
        this.tagPos = tagPos;
        this.add = add;
        this.tag = tag;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.add);
        buf.m_130070_(this.tag);
        buf.m_130064_(this.anchorPos);
        buf.m_130064_(this.tagPos);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        if (ctxIn.getSender() == null) {
            return;
        }
        BlockEntity te = ctxIn.getSender().m_9236_().m_7702_(this.anchorPos);
        if (te instanceof IBlueprintDataProviderBE) {
            IBlueprintDataProviderBE dataTE = (IBlueprintDataProviderBE)te;
            if (this.add) {
                dataTE.addTag(this.tagPos, this.tag);
            } else {
                dataTE.removeTag(this.tagPos, this.tag);
            }
        } else {
            Log.getLogger().info("Tried to add data tag to invalid tileentity:" + String.valueOf(te));
        }
    }
}

