/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.storage.rendering;

import com.ldtteam.structurize.Network;
import com.ldtteam.structurize.network.messages.SyncPreviewCacheToClient;
import com.ldtteam.structurize.storage.rendering.RenderingCache;
import com.ldtteam.structurize.storage.rendering.types.BlueprintPreviewData;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ServerPreviewDistributor {
    private static Object2BooleanMap<UUID> registeredPlayers = new Object2BooleanOpenHashMap();

    @SubscribeEvent
    public static void onLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getEntity().m_9236_().f_46443_) {
            RenderingCache.clear();
            return;
        }
        registeredPlayers.removeBoolean((Object)event.getEntity().m_20148_());
    }

    public static void distribute(BlueprintPreviewData renderingCache, ServerPlayer sourcePlayer) {
        for (ServerPlayer player : sourcePlayer.m_20194_().m_129880_(sourcePlayer.m_9236_().m_46472_()).m_6907_()) {
            if (!(player.m_20183_().m_123331_((Vec3i)renderingCache.getPos()) < 16384.0) && !renderingCache.getPos().equals((Object)BlockPos.f_121853_) || player.m_20148_().equals(sourcePlayer.m_20148_()) || !player.m_6084_() || !registeredPlayers.getBoolean((Object)player.m_20148_())) continue;
            Network.getNetwork().sendToPlayer(new SyncPreviewCacheToClient(renderingCache, player.m_20148_()), player);
        }
    }

    public static void register(ServerPlayer player, boolean displayShared) {
        registeredPlayers.put((Object)player.m_20148_(), displayShared);
    }
}

