/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.core.living;

import com.google.common.collect.Multimap;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.common.item.ItemLivingTrainer;
import wayoftime.bloodmagic.core.living.ILivingContainer;
import wayoftime.bloodmagic.core.living.LivingStats;
import wayoftime.bloodmagic.core.living.LivingUpgrade;
import wayoftime.bloodmagic.core.util.PlayerUtil;
import wayoftime.bloodmagic.event.LivingEquipmentEvent;

public class LivingUtil {
    public static Pair<LivingStats, Boolean> applyNewExperience(Player player, LivingUpgrade upgrade, double experience) {
        double curExp;
        LivingStats stats = LivingStats.fromPlayer(player, true);
        if (stats == null) {
            return Pair.of(null, (Object)false);
        }
        double d = curExp = stats.getUpgrades().containsKey(upgrade) ? stats.getUpgrades().get(upgrade) : 0.0;
        if (!LivingUtil.canTrain(player, upgrade, upgrade.getLevel((int)curExp), upgrade.getLevel((int)(curExp + experience)))) {
            return Pair.of((Object)stats, (Object)false);
        }
        LivingEquipmentEvent.GainExperience event = new LivingEquipmentEvent.GainExperience(player, stats, upgrade, experience);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return Pair.of((Object)stats, (Object)false);
        }
        experience = event.getExperience();
        double currentExperience = stats.getUpgrades().getOrDefault(upgrade, 0.0);
        double requiredForLevel = (double)upgrade.getNextRequirement((int)currentExperience) - currentExperience;
        if (requiredForLevel <= experience) {
            int currentPoints = stats.getUsedPoints();
            if (currentPoints >= stats.getMaxPoints()) {
                return Pair.of((Object)stats, (Object)false);
            }
            int currentPointCost = upgrade.getLevelCost(upgrade.getLevel((int)currentExperience));
            int nextPointCost = upgrade.getLevelCost(upgrade.getLevel((int)(currentExperience + experience)));
            if (nextPointCost == -1) {
                return Pair.of((Object)stats, (Object)false);
            }
            int pointDif = nextPointCost - currentPointCost;
            if (pointDif < 0 && !upgrade.isNegative()) {
                return Pair.of((Object)stats, (Object)false);
            }
            if (currentPoints + pointDif > stats.getMaxPoints()) {
                return Pair.of((Object)stats, (Object)false);
            }
        }
        int newLevel = upgrade.getLevel((int)(currentExperience + experience));
        boolean didUpgrade = false;
        if (upgrade.getLevel((int)currentExperience) != newLevel) {
            LivingEquipmentEvent.LevelUp levelUpEvent = new LivingEquipmentEvent.LevelUp(player, stats, upgrade);
            MinecraftForge.EVENT_BUS.post((Event)levelUpEvent);
            didUpgrade = true;
            player.m_5661_((Component)Component.m_237110_((String)"chat.bloodmagic.living_upgrade_level_increase", (Object[])new Object[]{Component.m_237115_((String)upgrade.getTranslationKey()), newLevel}), true);
        }
        stats.addExperience(upgrade.getKey(), experience);
        LivingStats.toPlayer(player, stats);
        return Pair.of((Object)stats, (Object)didUpgrade);
    }

    public static Pair<LivingStats, Double> applyExperienceToUpgradeCap(Player player, LivingUpgrade upgrade, double experience) {
        int potentialLevel;
        double curExp;
        LivingStats stats = LivingStats.fromPlayer(player, true);
        if (stats == null) {
            return Pair.of(null, (Object)0.0);
        }
        double d = curExp = stats.getUpgrades().containsKey(upgrade) ? stats.getUpgrades().get(upgrade) : 0.0;
        if (!LivingUtil.canTrain(player, upgrade, upgrade.getLevel((int)curExp), upgrade.getLevel((int)(curExp + experience)))) {
            return Pair.of((Object)stats, (Object)0.0);
        }
        LivingEquipmentEvent.GainExperience event = new LivingEquipmentEvent.GainExperience(player, stats, upgrade, experience);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return Pair.of((Object)stats, (Object)0.0);
        }
        double multiplicationFactor = event.getExperience() / experience;
        experience = event.getExperience();
        if (experience <= 0.0) {
            return Pair.of((Object)stats, (Object)0.0);
        }
        double currentExperience = stats.getUpgrades().getOrDefault(upgrade, 0.0);
        int currentLevel = upgrade.getLevel((int)currentExperience);
        double requiredForLevel = (double)upgrade.getNextRequirement((int)currentExperience) - currentExperience;
        if (requiredForLevel <= experience) {
            int currentPoints = stats.getUsedPoints();
            if (currentPoints >= stats.getMaxPoints()) {
                return Pair.of((Object)stats, (Object)0.0);
            }
            int currentPointCost = upgrade.getLevelCost(currentLevel);
            for (potentialLevel = upgrade.getLevel((int)(currentExperience + experience)); potentialLevel > currentLevel; --potentialLevel) {
                int nextPointCost = upgrade.getLevelCost(potentialLevel);
                if (nextPointCost == -1) {
                    return Pair.of((Object)stats, (Object)0.0);
                }
                int pointDif = nextPointCost - currentPointCost;
                if (pointDif < 0 && !upgrade.isNegative()) {
                    return Pair.of((Object)stats, (Object)0.0);
                }
                if (currentPoints + pointDif <= stats.getMaxPoints()) break;
                experience = (double)upgrade.getLevelExp(potentialLevel) - currentExperience - 1.0;
                if (!(experience <= 0.0)) continue;
                return Pair.of((Object)stats, (Object)0.0);
            }
            if (experience < 0.0) {
                return Pair.of((Object)stats, (Object)0.0);
            }
        }
        if (potentialLevel == 0) {
            return Pair.of((Object)stats, (Object)0.0);
        }
        int newLevel = upgrade.getLevel((int)(currentExperience + experience));
        boolean didUpgrade = false;
        if (upgrade.getLevel((int)currentExperience) != newLevel) {
            LivingEquipmentEvent.LevelUp levelUpEvent = new LivingEquipmentEvent.LevelUp(player, stats, upgrade);
            MinecraftForge.EVENT_BUS.post((Event)levelUpEvent);
            didUpgrade = true;
            player.m_5661_((Component)Component.m_237110_((String)"chat.bloodmagic.living_upgrade_level_increase", (Object[])new Object[]{Component.m_237115_((String)upgrade.getTranslationKey()), newLevel}), true);
        }
        stats.addExperience(upgrade.getKey(), experience);
        LivingStats.toPlayer(player, stats);
        return Pair.of((Object)stats, (Object)(experience / multiplicationFactor));
    }

    public static double getDamageReceivedForArmour(Player player, DamageSource source, double damage) {
        LivingStats stats = LivingStats.fromPlayer(player, true);
        if (stats == null) {
            return damage;
        }
        Map<LivingUpgrade, Double> upgrades = stats.getUpgrades();
        for (Map.Entry<LivingUpgrade, Double> entry : upgrades.entrySet()) {
            LivingUpgrade upgrade = entry.getKey();
            if (upgrade.getArmorProvider() == null) continue;
            int level = upgrade.getLevel(entry.getValue().intValue());
            damage *= 1.0 - upgrade.getArmorProvider().getProtection(player, stats, source, upgrade, level);
        }
        return damage;
    }

    public static double getAdditionalDamage(Player player, ItemStack weapon, LivingEntity attackedEntity, double damage) {
        LivingStats stats = LivingStats.fromPlayer(player, true);
        if (stats == null) {
            return 0.0;
        }
        double additionalDamage = 0.0;
        Map<LivingUpgrade, Double> upgrades = stats.getUpgrades();
        for (Map.Entry<LivingUpgrade, Double> entry : upgrades.entrySet()) {
            LivingUpgrade upgrade = entry.getKey();
            if (upgrade.getArmorProvider() == null) continue;
            int level = upgrade.getLevel(entry.getValue().intValue());
            if (upgrade.getDamageProvider() == null) continue;
            additionalDamage += upgrade.getDamageProvider().getAdditionalDamage(player, weapon, damage, stats, attackedEntity, upgrade, level);
        }
        return additionalDamage;
    }

    public static boolean canTrain(Player player, LivingUpgrade upgrade, int currentLevel, int nextLevel) {
        ItemStack trainer = PlayerUtil.findItem(player, stack -> stack.m_41720_() instanceof ItemLivingTrainer && stack.m_41782_() && stack.m_41783_().m_128441_("livingStats"));
        if (trainer.m_41619_()) {
            return true;
        }
        LivingStats stats = ((ILivingContainer)trainer.m_41720_()).getLivingStats(trainer);
        boolean isWhitelist = ((ItemLivingTrainer)trainer.m_41720_()).getIsWhitelist(trainer);
        int levelLimit = stats.getLevel(upgrade.getKey());
        if (isWhitelist) {
            return levelLimit != 0 && (levelLimit > currentLevel || nextLevel != currentLevel && levelLimit >= nextLevel);
        }
        Map<LivingUpgrade, Double> upgradeMap = stats.getUpgrades();
        return levelLimit == 0 && !upgradeMap.containsKey(upgrade) || levelLimit != 0 && (levelLimit > currentLevel || nextLevel != currentLevel && levelLimit >= nextLevel);
    }

    public static boolean hasFullSet(Player player) {
        for (ItemStack stack : player.m_150109_().f_35975_) {
            if (stack.m_41619_() || !(stack.m_41720_() instanceof ILivingContainer)) {
                return false;
            }
            if (!(stack.m_41720_() instanceof ArmorItem) || ((ArmorItem)stack.m_41720_()).m_266204_() != ArmorItem.Type.CHESTPLATE || stack.m_41776_() - stack.m_41773_() > 1) continue;
            return false;
        }
        return true;
    }

    public static void applyAttributes(Multimap<Attribute, AttributeModifier> attributes, ItemStack stack, Player player, EquipmentSlot slot) {
        if (player == null || !LivingUtil.hasFullSet(player)) {
            return;
        }
        Multimap newAttributes = ((ArmorItem)stack.m_41720_()).getAttributeModifiers(slot, stack);
        attributes.putAll(newAttributes);
    }
}

