/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.block.multi;

import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import org.cyclops.cyclopscore.block.multi.ISizeValidator;
import org.cyclops.cyclopscore.block.multi.SizeValidators;
import org.cyclops.cyclopscore.helper.LocationHelpers;

public class ExactSizeValidator
implements ISizeValidator {
    private final Vec3i exactSize;

    @Override
    public Component isSizeValid(Vec3i size) {
        if (SizeValidators.compareVec3i(size, this.getExactSize()) == 0) {
            return null;
        }
        return Component.m_237110_((String)"multiblock.cyclopscore.error.size.exact", (Object[])new Object[]{LocationHelpers.toCompactString(size.m_7918_(1, 1, 1)), LocationHelpers.toCompactString(this.getExactSize().m_7918_(1, 1, 1))});
    }

    public ExactSizeValidator(Vec3i exactSize) {
        this.exactSize = exactSize;
    }

    public Vec3i getExactSize() {
        return this.exactSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExactSizeValidator)) {
            return false;
        }
        ExactSizeValidator other = (ExactSizeValidator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Vec3i this$exactSize = this.getExactSize();
        Vec3i other$exactSize = other.getExactSize();
        return !(this$exactSize == null ? other$exactSize != null : !this$exactSize.equals(other$exactSize));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExactSizeValidator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Vec3i $exactSize = this.getExactSize();
        result = result * 59 + ($exactSize == null ? 43 : $exactSize.hashCode());
        return result;
    }

    public String toString() {
        return "ExactSizeValidator(exactSize=" + String.valueOf(this.getExactSize()) + ")";
    }
}

