/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook.pageelement;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Style;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.StringUtils;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.ScreenInfoBook;
import org.cyclops.cyclopscore.infobook.pageelement.SectionAppendix;

public class TextFieldAppendix
extends SectionAppendix {
    private static final int OFFSET_Y = 0;
    private final String text;
    private final double scale;
    private int height;
    private int maxWidth;
    private List<String> lines = null;

    public TextFieldAppendix(IInfoBook infoBook, String text, double scale) {
        super(infoBook);
        this.text = text;
        this.scale = scale;
        this.height = this.text.split("\n").length * 9;
        DistExecutor.callWhenOn((Dist)Dist.CLIENT, () -> () -> {
            this.calculateLines();
            return null;
        });
    }

    @Override
    protected int getOffsetY() {
        return 0;
    }

    @Override
    protected int getWidth() {
        return this.maxWidth == 0 ? 120 : this.maxWidth;
    }

    @Override
    protected int getHeight() {
        return this.height;
    }

    protected void calculateLines() {
        Font font = Minecraft.m_91087_().f_91062_;
        StringSplitter stringSplitter = font.m_92865_();
        this.lines = Lists.newArrayList();
        stringSplitter.m_92364_(this.text, this.getWidth(), Style.f_131099_, true, (style, startPos, endPos) -> {
            String stringPart = this.text.substring(startPos, endPos);
            String line = StringUtils.stripEnd((String)stringPart, (String)" \n");
            this.lines.add(line);
            this.maxWidth = (int)Math.max((double)this.maxWidth, (double)font.m_92895_(line) * this.scale);
        });
        double d = this.scale * (double)this.lines.size();
        Objects.requireNonNull(font);
        this.height = (int)(d * 9.0);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void drawElement(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, int width, int height, int page, int mx, int my) {
        int lineId = 0;
        for (String line : this.lines) {
            Font font = gui.getFont();
            double d = y;
            float f = lineId;
            Objects.requireNonNull(gui.getFont());
            RenderHelpers.drawScaledString(guiGraphics, font, line, x, (int)(d + (double)(f * 9.0f) * this.scale), (float)this.scale, Helpers.RGBToInt(10, 10, 10), false, Font.DisplayMode.NORMAL);
            ++lineId;
        }
        gui.drawOuterBorder(guiGraphics, x - 1, y - 1, this.getWidth() + 2, this.getHeight() + 2, 0.5f, 0.5f, 0.5f, 0.4f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void postDrawElement(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, int width, int height, int page, int mx, int my) {
    }

    @Override
    public void preBakeElement(InfoSection infoSection) {
    }

    @Override
    public void bakeElement(InfoSection infoSection) {
    }
}

