/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.custom.train.locomotive;

import dev.murad.shipping.ShippingConfig;
import dev.murad.shipping.capability.ReadWriteEnergyStorage;
import dev.murad.shipping.entity.accessor.EnergyHeadVehicleDataAccessor;
import dev.murad.shipping.entity.container.EnergyHeadVehicleContainer;
import dev.murad.shipping.entity.custom.train.locomotive.AbstractLocomotiveEntity;
import dev.murad.shipping.setup.ModEntityTypes;
import dev.murad.shipping.setup.ModItems;
import dev.murad.shipping.util.InventoryUtils;
import dev.murad.shipping.util.ItemHandlerVanillaContainerWrapper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class EnergyLocomotiveEntity
extends AbstractLocomotiveEntity
implements ItemHandlerVanillaContainerWrapper,
WorldlyContainer {
    private final ItemStackHandler energyItemHandler = this.createHandler();
    private final LazyOptional<IItemHandler> energyItemHandlerOpt = LazyOptional.of(() -> this.energyItemHandler);
    private static final int MAX_ENERGY = (Integer)ShippingConfig.Server.ENERGY_LOCO_BASE_CAPACITY.get();
    private static final int MAX_TRANSFER = (Integer)ShippingConfig.Server.ENERGY_LOCO_BASE_MAX_CHARGE_RATE.get();
    private static final int ENERGY_USAGE = (Integer)ShippingConfig.Server.ENERGY_LOCO_BASE_ENERGY_USAGE.get();
    private final ReadWriteEnergyStorage internalBattery = new ReadWriteEnergyStorage(MAX_ENERGY, MAX_TRANSFER, Integer.MAX_VALUE);
    private final LazyOptional<IEnergyStorage> internalBatteryOpt = LazyOptional.of(() -> this.internalBattery);

    public EnergyLocomotiveEntity(EntityType<?> type, Level level) {
        super(type, level);
        this.internalBattery.setEnergy(0);
    }

    public EnergyLocomotiveEntity(Level level, Double x, Double y, Double z) {
        super((EntityType<?>)((EntityType)ModEntityTypes.ENERGY_LOCOMOTIVE.get()), level, x, y, z);
        this.internalBattery.setEnergy(0);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.getCapability(ForgeCapabilities.ENERGY).isPresent();
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.energyItemHandlerOpt.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.internalBatteryOpt.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_142687_(Entity.RemovalReason r) {
        if (!this.m_9236_().f_46443_) {
            Containers.m_18998_((Level)this.m_9236_(), (Entity)this, (Container)this);
        }
        super.m_142687_(r);
    }

    @Override
    protected MenuProvider createContainerProvider() {
        return new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237115_((String)"entity.littlelogistics.energy_locomotive");
            }

            public AbstractContainerMenu m_7208_(int i, @NotNull Inventory playerInventory, @NotNull Player player) {
                return new EnergyHeadVehicleContainer(i, EnergyLocomotiveEntity.this.m_9236_(), EnergyLocomotiveEntity.this.getDataAccessor(), playerInventory, player);
            }
        };
    }

    @Override
    public EnergyHeadVehicleDataAccessor getDataAccessor() {
        return (EnergyHeadVehicleDataAccessor)new EnergyHeadVehicleDataAccessor.Builder().withEnergy(this.internalBattery::getEnergyStored).withCapacity(this.internalBattery::getMaxEnergyStored).withLit(() -> this.internalBattery.getEnergyStored() > 0).withId(this.m_19879_()).withOn(() -> this.engineOn).withRouteSize(() -> this.navigator.getRouteSize()).withVisitedSize(() -> this.navigator.getVisitedSize()).withCanMove(this.enrollmentHandler::mayMove).build();
    }

    @Override
    public void m_8119_() {
        IEnergyStorage capability;
        if (!this.m_9236_().f_46443_ && (capability = InventoryUtils.getEnergyCapabilityInSlot(0, this.energyItemHandler)) != null) {
            int toExtract = capability.extractEnergy(MAX_TRANSFER, true);
            toExtract = this.internalBattery.receiveEnergy(toExtract, false);
            capability.extractEnergy(toExtract, false);
        }
        super.m_8119_();
    }

    @Override
    protected boolean tickFuel() {
        return this.internalBattery.extractEnergy(ENERGY_USAGE, false) > 0;
    }

    @Override
    @NotNull
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)ModItems.ENERGY_LOCOMOTIVE.get());
    }

    @Override
    public ItemStackHandler getRawHandler() {
        return this.energyItemHandler;
    }

    public int @NotNull [] m_7071_(@NotNull Direction dir) {
        return new int[]{0};
    }

    public boolean m_7155_(int index, @NotNull ItemStack itemStack, @Nullable Direction dir) {
        return this.stalling.isDocked();
    }

    public boolean m_7157_(int index, @NotNull ItemStack itemStack, @NotNull Direction dir) {
        return false;
    }

    @Override
    public void m_7378_(@NotNull CompoundTag compound) {
        this.energyItemHandler.deserializeNBT(compound.m_128469_("inv"));
        this.internalBattery.readAdditionalSaveData(compound.m_128469_("energy_storage"));
        super.m_7378_(compound);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag compound) {
        compound.m_128365_("inv", (Tag)this.energyItemHandler.serializeNBT());
        CompoundTag energyNBT = new CompoundTag();
        this.internalBattery.addAdditionalSaveData(energyNBT);
        compound.m_128365_("energy_storage", (Tag)energyNBT);
        super.m_7380_(compound);
    }
}

