/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.custom.train.locomotive;

import dev.murad.shipping.ShippingConfig;
import dev.murad.shipping.entity.accessor.SteamHeadVehicleDataAccessor;
import dev.murad.shipping.entity.container.SteamHeadVehicleContainer;
import dev.murad.shipping.entity.custom.train.locomotive.AbstractLocomotiveEntity;
import dev.murad.shipping.entity.custom.vessel.tug.AbstractTugEntity;
import dev.murad.shipping.setup.ModEntityTypes;
import dev.murad.shipping.setup.ModItems;
import dev.murad.shipping.setup.ModSounds;
import dev.murad.shipping.util.FuelItemStackHandler;
import dev.murad.shipping.util.ItemHandlerVanillaContainerWrapper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class SteamLocomotiveEntity
extends AbstractLocomotiveEntity
implements ItemHandlerVanillaContainerWrapper,
WorldlyContainer {
    private final FuelItemStackHandler fuelItemHandler = new FuelItemStackHandler();
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.fuelItemHandler);
    private static final ForgeConfigSpec.ConfigValue<Double> FURNACE_FUEL_MULTIPLIER = ShippingConfig.Server.STEAM_LOCO_FUEL_MULTIPLIER;
    protected int burnTime = 0;
    protected int burnCapacity = 0;

    public boolean isLit() {
        return this.burnTime > 0;
    }

    public int getBurnProgress() {
        int i = this.burnCapacity;
        if (i == 0) {
            i = 200;
        }
        return this.burnTime * 13 / i;
    }

    @Override
    public SteamHeadVehicleDataAccessor getDataAccessor() {
        return (SteamHeadVehicleDataAccessor)new SteamHeadVehicleDataAccessor.Builder().withBurnProgress(this::getBurnProgress).withId(this.m_19879_()).withOn(() -> this.engineOn).withRouteSize(() -> this.navigator.getRouteSize()).withVisitedSize(() -> this.navigator.getVisitedSize()).withLit(this::isLit).withCanMove(this.enrollmentHandler::mayMove).build();
    }

    @Override
    protected boolean tickFuel() {
        int adjustedBurnTime;
        if (this.burnTime > 0) {
            --this.burnTime;
            return true;
        }
        int burnTime = this.fuelItemHandler.tryConsumeFuel();
        this.burnCapacity = adjustedBurnTime = (int)Math.ceil((double)burnTime * (Double)FURNACE_FUEL_MULTIPLIER.get());
        this.burnTime = adjustedBurnTime;
        return adjustedBurnTime > 0;
    }

    @Override
    protected void onUndock() {
        super.onUndock();
        this.m_5496_((SoundEvent)ModSounds.STEAM_TUG_WHISTLE.get(), 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
    }

    @Override
    protected MenuProvider createContainerProvider() {
        return new MenuProvider(){

            @NotNull
            public Component m_5446_() {
                return Component.m_237115_((String)"entity.littlelogistics.steam_locomotive");
            }

            public AbstractContainerMenu m_7208_(int i, @NotNull Inventory playerInventory, @NotNull Player player) {
                return new SteamHeadVehicleContainer(i, SteamLocomotiveEntity.this.m_9236_(), SteamLocomotiveEntity.this.getDataAccessor(), playerInventory, player);
            }
        };
    }

    @Override
    public void m_142687_(Entity.RemovalReason r) {
        if (!this.m_9236_().f_46443_) {
            Containers.m_18998_((Level)this.m_9236_(), (Entity)this, (Container)this);
        }
        super.m_142687_(r);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public SteamLocomotiveEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public SteamLocomotiveEntity(Level level, Double x, Double y, Double z) {
        super((EntityType<?>)((EntityType)ModEntityTypes.STEAM_LOCOMOTIVE.get()), level, x, y, z);
    }

    @Override
    @NotNull
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)ModItems.STEAM_LOCOMOTIVE.get());
    }

    @Override
    protected void doMovementEffect() {
        Level level = this.m_9236_();
        BlockPos blockpos = this.m_20097_().m_7494_().m_7494_();
        RandomSource random = level.f_46441_;
        if ((double)random.m_188501_() < (Double)ShippingConfig.Client.LOCO_SMOKE_MODIFIER.get()) {
            for (int i = 0; i < random.m_188503_(2) + 2; ++i) {
                AbstractTugEntity.makeParticles(level, blockpos, (Entity)this);
            }
        }
    }

    public boolean m_7157_(int index, @NotNull ItemStack itemStack, @NotNull Direction dir) {
        return false;
    }

    public int @NotNull [] m_7071_(@NotNull Direction dir) {
        return new int[]{0};
    }

    public boolean m_7155_(int index, @NotNull ItemStack itemStack, @Nullable Direction dir) {
        return this.stalling.isDocked();
    }

    @Override
    public ItemStackHandler getRawHandler() {
        return this.fuelItemHandler;
    }

    @Override
    public void m_7378_(@NotNull CompoundTag compound) {
        this.fuelItemHandler.deserializeNBT(compound.m_128469_("fuelItems"));
        this.burnTime = compound.m_128441_("burn") ? compound.m_128451_("burn") : 0;
        this.burnCapacity = compound.m_128441_("burn_capacity") ? compound.m_128451_("burn_capacity") : 0;
        super.m_7378_(compound);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag compound) {
        compound.m_128365_("fuelItems", (Tag)this.fuelItemHandler.serializeNBT());
        compound.m_128405_("burn", this.burnTime);
        compound.m_128405_("burn_capacity", this.burnCapacity);
        super.m_7380_(compound);
    }
}

