/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.custom.vessel.barge;

import dev.murad.shipping.capability.StallingCapability;
import dev.murad.shipping.entity.custom.vessel.VesselEntity;
import dev.murad.shipping.entity.custom.vessel.tug.AbstractTugEntity;
import dev.murad.shipping.util.Train;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public abstract class AbstractBargeEntity
extends VesselEntity {
    private final StallingCapability capability = new StallingCapability(){

        @Override
        public boolean isDocked() {
            return this.delegate().map(StallingCapability::isDocked).orElse(false);
        }

        @Override
        public void dock(double x, double y, double z) {
            this.delegate().ifPresent(s -> s.dock(x, y, z));
        }

        @Override
        public void undock() {
            this.delegate().ifPresent(StallingCapability::undock);
        }

        @Override
        public boolean isStalled() {
            return this.delegate().map(StallingCapability::isStalled).orElse(false);
        }

        @Override
        public void stall() {
            this.delegate().ifPresent(StallingCapability::stall);
        }

        @Override
        public void unstall() {
            this.delegate().ifPresent(StallingCapability::unstall);
        }

        @Override
        public boolean isFrozen() {
            return AbstractBargeEntity.super.isFrozen();
        }

        @Override
        public void freeze() {
            AbstractBargeEntity.super.setFrozen(true);
        }

        @Override
        public void unfreeze() {
            AbstractBargeEntity.super.setFrozen(false);
        }

        private Optional<StallingCapability> delegate() {
            Object t = ((AbstractBargeEntity)AbstractBargeEntity.this).linkingHandler.train.getHead();
            if (t instanceof AbstractTugEntity) {
                AbstractTugEntity e = (AbstractTugEntity)t;
                return e.getCapability(StallingCapability.STALLING_CAPABILITY).resolve();
            }
            return Optional.empty();
        }
    };
    private final LazyOptional<StallingCapability> capabilityOpt = LazyOptional.of(() -> this.capability);

    public AbstractBargeEntity(EntityType<? extends AbstractBargeEntity> type, Level world) {
        super(type, world);
        this.f_19850_ = true;
        this.linkingHandler.train = new Train<AbstractBargeEntity>(this);
    }

    public AbstractBargeEntity(EntityType<? extends AbstractBargeEntity> type, Level worldIn, double x, double y, double z) {
        this(type, worldIn);
        this.m_6034_(x, y, z);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    protected boolean m_7310_(Entity passenger) {
        return false;
    }

    @Override
    public abstract Item getDropItem();

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (!this.m_9236_().f_46443_) {
            DyeColor color = DyeColor.getColor((ItemStack)player.m_21120_(hand));
            if (color != null) {
                this.m_20088_().m_135381_(COLOR_DATA, (Object)color.m_41060_());
            } else {
                this.doInteract(player);
            }
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
    }

    protected abstract void doInteract(Player var1);

    @Override
    public boolean hasWaterOnSides() {
        return super.hasWaterOnSides();
    }

    @Override
    public void setDominated(VesselEntity entity) {
        this.linkingHandler.follower = Optional.of(entity);
    }

    @Override
    public void setDominant(VesselEntity entity) {
        this.setTrain(entity.getTrain());
        this.linkingHandler.leader = Optional.of(entity);
    }

    @Override
    public void removeDominated() {
        if (!this.m_6084_()) {
            return;
        }
        this.linkingHandler.follower = Optional.empty();
        this.linkingHandler.train.setTail(this);
    }

    @Override
    public void removeDominant() {
        if (!this.m_6084_()) {
            return;
        }
        this.linkingHandler.leader = Optional.empty();
        this.setTrain(new Train<VesselEntity>(this));
    }

    @Override
    public void setTrain(Train<VesselEntity> train) {
        this.linkingHandler.train = train;
        train.setTail(this);
        this.linkingHandler.follower.ifPresent(dominated -> {
            if (!dominated.getTrain().equals(train)) {
                dominated.setTrain(train);
            }
        });
    }

    @Override
    public void m_142687_(Entity.RemovalReason r) {
        if (!this.m_9236_().f_46443_) {
            ItemStack stack = new ItemStack((ItemLike)this.getDropItem());
            if (this.m_8077_()) {
                stack.m_41714_(this.m_7770_());
            }
            this.m_19983_(stack);
        }
        super.m_142687_(r);
    }

    public boolean isDockable() {
        return this.linkingHandler.leader.map(dom -> this.m_20280_((Entity)dom) < 1.1).orElse(true);
    }

    @Override
    public boolean allowDockInterface() {
        return this.isDockable();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        if (cap == StallingCapability.STALLING_CAPABILITY) {
            return this.capabilityOpt.cast();
        }
        return super.getCapability(cap);
    }
}

