/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.custom.vessel.barge;

import dev.murad.shipping.entity.custom.TrainInventoryProvider;
import dev.murad.shipping.entity.custom.vessel.barge.AbstractBargeEntity;
import dev.murad.shipping.setup.ModEntityTypes;
import dev.murad.shipping.setup.ModItems;
import dev.murad.shipping.util.InventoryUtils;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class ChestBargeEntity
extends AbstractBargeEntity
implements Container,
MenuProvider,
WorldlyContainer,
TrainInventoryProvider {
    protected final ItemStackHandler itemHandler = new ItemStackHandler(27);

    public ChestBargeEntity(EntityType<? extends ChestBargeEntity> type, Level world) {
        super((EntityType<? extends AbstractBargeEntity>)type, world);
    }

    public ChestBargeEntity(EntityType<? extends ChestBargeEntity> type, Level world, double x, double y, double z) {
        super(type, world, x, y, z);
    }

    @Override
    public void m_142687_(Entity.RemovalReason r) {
        if (!this.m_9236_().f_46443_) {
            Containers.m_18998_((Level)this.m_9236_(), (Entity)this, (Container)this);
        }
        super.m_142687_(r);
    }

    @Override
    public Item getDropItem() {
        if (this.m_6095_().equals(ModEntityTypes.BARREL_BARGE.get())) {
            return (Item)ModItems.BARREL_BARGE.get();
        }
        return (Item)ModItems.CHEST_BARGE.get();
    }

    @Override
    protected void doInteract(Player player) {
        player.m_5893_((MenuProvider)this);
    }

    public int m_6643_() {
        return this.itemHandler.getSlots();
    }

    public boolean m_7983_() {
        return InventoryUtils.isEmpty(this.itemHandler);
    }

    @NotNull
    public ItemStack m_8020_(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }

    @NotNull
    public ItemStack m_7407_(int slot, int count) {
        return this.itemHandler.extractItem(slot, count, false);
    }

    @NotNull
    public ItemStack m_8016_(int slot) {
        ItemStack itemstack = this.itemHandler.getStackInSlot(slot);
        if (itemstack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.itemHandler.setStackInSlot(slot, ItemStack.f_41583_);
        return itemstack;
    }

    public void m_6836_(int slot, @NotNull ItemStack stack) {
        this.itemHandler.setStackInSlot(slot, stack);
    }

    public void m_6596_() {
    }

    public boolean m_6542_(Player player) {
        if (this.m_213877_()) {
            return false;
        }
        return !(player.m_20280_((Entity)this) > 64.0);
    }

    public void m_6211_() {
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pInventory, Player pPlayer) {
        if (pPlayer.m_5833_()) {
            return null;
        }
        return ChestMenu.m_39237_((int)pContainerId, (Inventory)pInventory, (Container)this);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128365_("Items", (Tag)this.itemHandler.serializeNBT());
    }

    @Override
    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("Items"));
    }

    public int[] m_7071_(Direction face) {
        return IntStream.range(0, this.m_6643_()).toArray();
    }

    public boolean m_7155_(int p_180462_1_, ItemStack item, @Nullable Direction p_180462_3_) {
        return this.isDockable();
    }

    public boolean m_7157_(int p_180461_1_, ItemStack item, Direction p_180461_3_) {
        return this.isDockable();
    }

    @Override
    public Optional<ItemStackHandler> getTrainInventoryHandler() {
        return Optional.of(this.itemHandler);
    }
}

