/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.render.barge;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.murad.shipping.entity.custom.vessel.VesselEntity;
import dev.murad.shipping.entity.models.train.ChainModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public abstract class AbstractVesselRenderer<T extends VesselEntity>
extends EntityRenderer<T> {
    private static final ResourceLocation CHAIN_TEXTURE = new ResourceLocation("littlelogistics", "textures/entity/chain.png");
    private final ChainModel chainModel;

    public AbstractVesselRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.chainModel = new ChainModel(context.m_174023_(ChainModel.LAYER_LOCATION));
    }

    public void render(T vesselEntity, float yaw, float partialTick, PoseStack matrixStack, MultiBufferSource buffer, int p_225623_6_) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, this.getModelYoffset(), 0.0);
        matrixStack.m_85837_(0.0, 0.07, 0.0);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - yaw));
        matrixStack.m_85841_(-1.0f, -1.0f, 1.0f);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(this.getModelYrot()));
        this.renderModel(vesselEntity, matrixStack, buffer, p_225623_6_);
        this.getAndRenderChain(vesselEntity, matrixStack, buffer, p_225623_6_);
        matrixStack.m_85849_();
        this.getAndRenderLeash(vesselEntity, yaw, partialTick, matrixStack, buffer, p_225623_6_);
    }

    protected void renderModel(T vesselEntity, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        VertexConsumer ivertexbuilder = buffer.m_6299_(this.getModel(vesselEntity).m_103119_(this.m_5478_((Entity)vesselEntity)));
        int overlay = LivingEntityRenderer.m_115338_(vesselEntity, (float)0.0f);
        this.getModel(vesselEntity).m_7695_(matrixStack, ivertexbuilder, packedLight, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected double getModelYoffset() {
        return 0.275;
    }

    protected float getModelYrot() {
        return 90.0f;
    }

    private void getAndRenderChain(T bargeEntity, PoseStack matrixStack, MultiBufferSource buffer, int p_225623_6_) {
        if (((VesselEntity)bargeEntity).getLeader().isPresent()) {
            double dist = ((VesselEntity)bargeEntity).getLeader().get().m_20270_((Entity)bargeEntity);
            VertexConsumer ivertexbuilderChain = buffer.m_6299_(this.chainModel.m_103119_(CHAIN_TEXTURE));
            int segments = (int)Math.ceil(dist * 4.0);
            matrixStack.m_85836_();
            for (int i = 0; i < segments; ++i) {
                matrixStack.m_85836_();
                matrixStack.m_85837_((double)i / 4.0, 0.0, 0.0);
                this.chainModel.m_7695_(matrixStack, ivertexbuilderChain, p_225623_6_, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                matrixStack.m_85849_();
            }
            matrixStack.m_85849_();
        }
    }

    private void getAndRenderLeash(T bargeEntity, float p_225623_2_, float p_225623_3_, PoseStack matrixStack, MultiBufferSource buffer, int p_225623_6_) {
        matrixStack.m_85836_();
        Entity entity = bargeEntity.m_21524_();
        super.m_7392_(bargeEntity, p_225623_2_, p_225623_3_, matrixStack, buffer, p_225623_6_);
        if (entity != null) {
            matrixStack.m_85836_();
            this.renderLeash(bargeEntity, p_225623_3_, matrixStack, buffer, entity);
            matrixStack.m_85849_();
        }
        matrixStack.m_85849_();
    }

    public boolean shouldRender(T p_225626_1_, Frustum p_225626_2_, double p_225626_3_, double p_225626_5_, double p_225626_7_) {
        if (((VesselEntity)p_225626_1_).getLeader().isPresent()) {
            if (((VesselEntity)p_225626_1_).getLeader().get().m_6000_(p_225626_3_, p_225626_5_, p_225626_7_)) {
                return true;
            }
            if (((VesselEntity)p_225626_1_).getLeader().get().m_6000_(p_225626_3_, p_225626_5_, p_225626_7_)) {
                return true;
            }
        }
        return super.m_5523_(p_225626_1_, p_225626_2_, p_225626_3_, p_225626_5_, p_225626_7_);
    }

    abstract EntityModel<T> getModel(T var1);

    private <E extends Entity> void renderLeash(T pEntityLiving, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, E pLeashHolder) {
        int i;
        pMatrixStack.m_85836_();
        Vec3 vec3 = pLeashHolder.m_7398_(pPartialTicks);
        double d0 = (double)(Mth.m_14179_((float)pPartialTicks, (float)((VesselEntity)pEntityLiving).f_20883_, (float)((VesselEntity)pEntityLiving).f_20884_) * ((float)Math.PI / 180)) + 1.5707963267948966;
        Vec3 vec31 = pEntityLiving.m_245894_(pPartialTicks);
        double d1 = Math.cos(d0) * vec31.f_82481_ + Math.sin(d0) * vec31.f_82479_;
        double d2 = Math.sin(d0) * vec31.f_82481_ - Math.cos(d0) * vec31.f_82479_;
        double d3 = Mth.m_14139_((double)pPartialTicks, (double)((VesselEntity)pEntityLiving).f_19854_, (double)pEntityLiving.m_20185_()) + d1;
        double d4 = Mth.m_14139_((double)pPartialTicks, (double)((VesselEntity)pEntityLiving).f_19855_, (double)pEntityLiving.m_20186_()) + vec31.f_82480_;
        double d5 = Mth.m_14139_((double)pPartialTicks, (double)((VesselEntity)pEntityLiving).f_19856_, (double)pEntityLiving.m_20189_()) + d2;
        pMatrixStack.m_85837_(d1, vec31.f_82480_, d2);
        float f = (float)(vec3.f_82479_ - d3);
        float f1 = (float)(vec3.f_82480_ - d4);
        float f2 = (float)(vec3.f_82481_ - d5);
        float f3 = 0.025f;
        VertexConsumer vertexconsumer = pBuffer.m_6299_(RenderType.m_110475_());
        Matrix4f matrix4f = pMatrixStack.m_85850_().m_252922_();
        float f4 = Mth.m_264536_((float)(f * f + f2 * f2)) * 0.025f / 2.0f;
        float f5 = f2 * f4;
        float f6 = f * f4;
        BlockPos blockpos = BlockPos.m_274446_((Position)pEntityLiving.m_20299_(pPartialTicks));
        BlockPos blockpos1 = BlockPos.m_274446_((Position)pLeashHolder.m_20299_(pPartialTicks));
        int j = i = this.m_6086_((Entity)pEntityLiving, blockpos);
        int k = pEntityLiving.m_9236_().m_45517_(LightLayer.SKY, blockpos);
        int l = pEntityLiving.m_9236_().m_45517_(LightLayer.SKY, blockpos1);
        for (int i1 = 0; i1 <= 24; ++i1) {
            AbstractVesselRenderer.addVertexPair(vertexconsumer, matrix4f, f, f1, f2, i, j, k, l, 0.025f, 0.025f, f5, f6, i1, false);
        }
        for (int j1 = 24; j1 >= 0; --j1) {
            AbstractVesselRenderer.addVertexPair(vertexconsumer, matrix4f, f, f1, f2, i, j, k, l, 0.025f, 0.0f, f5, f6, j1, true);
        }
        pMatrixStack.m_85849_();
    }

    private static void addVertexPair(VertexConsumer p_174308_, Matrix4f p_174309_, float p_174310_, float p_174311_, float p_174312_, int p_174313_, int p_174314_, int p_174315_, int p_174316_, float p_174317_, float p_174318_, float p_174319_, float p_174320_, int p_174321_, boolean p_174322_) {
        float f = (float)p_174321_ / 24.0f;
        int i = (int)Mth.m_14179_((float)f, (float)p_174313_, (float)p_174314_);
        int j = (int)Mth.m_14179_((float)f, (float)p_174315_, (float)p_174316_);
        int k = LightTexture.m_109885_((int)i, (int)j);
        float f1 = p_174321_ % 2 == (p_174322_ ? 1 : 0) ? 0.7f : 1.0f;
        float f2 = 0.5f * f1;
        float f3 = 0.4f * f1;
        float f4 = 0.3f * f1;
        float f5 = p_174310_ * f;
        float f6 = p_174311_ > 0.0f ? p_174311_ * f * f : p_174311_ - p_174311_ * (1.0f - f) * (1.0f - f);
        float f7 = p_174312_ * f;
        p_174308_.m_252986_(p_174309_, f5 - p_174319_, f6 + p_174318_, f7 + p_174320_).m_85950_(f2, f3, f4, 1.0f).m_85969_(k).m_5752_();
        p_174308_.m_252986_(p_174309_, f5 + p_174319_, f6 + p_174317_ - p_174318_, f7 - p_174320_).m_85950_(f2, f3, f4, 1.0f).m_85969_(k).m_5752_();
    }
}

