/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.render.barge;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.murad.shipping.entity.custom.vessel.barge.FishingBargeEntity;
import dev.murad.shipping.entity.render.ModelPack;
import dev.murad.shipping.entity.render.ModelSupplier;
import dev.murad.shipping.entity.render.barge.MultipartVesselRenderer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;

public class FishingBargeRenderer<T extends FishingBargeEntity>
extends MultipartVesselRenderer<T> {
    private final EntityModel<T> transitionInsertModel;
    private final EntityModel<T> deployedInsertModel;
    private final ResourceLocation transitionInsertTextureLocation;
    private final ResourceLocation deployedInsertTextureLocation;

    protected FishingBargeRenderer(EntityRendererProvider.Context context, ModelPack<T> baseModelPack, ModelPack<T> stashedInsertModelPack, ModelPack<T> transitionInsertModelPack, ModelPack<T> deployedInsertModelPack, ModelPack<T> trimModelPack) {
        super(context, baseModelPack, stashedInsertModelPack, trimModelPack);
        this.transitionInsertModel = transitionInsertModelPack.supplier().supply(context.m_174023_(transitionInsertModelPack.location()));
        this.transitionInsertTextureLocation = transitionInsertModelPack.texture();
        this.deployedInsertModel = deployedInsertModelPack.supplier().supply(context.m_174023_(deployedInsertModelPack.location()));
        this.deployedInsertTextureLocation = deployedInsertModelPack.texture();
    }

    @Override
    protected void renderInsertModel(T vesselEntity, PoseStack matrixStack, MultiBufferSource buffer, int packedLight, int overlay) {
        EntityModel model = switch (((FishingBargeEntity)vesselEntity).getStatus()) {
            default -> throw new IncompatibleClassChangeError();
            case FishingBargeEntity.Status.STASHED -> this.getInsertModel();
            case FishingBargeEntity.Status.DEPLOYED -> this.deployedInsertModel;
            case FishingBargeEntity.Status.TRANSITION -> this.transitionInsertModel;
        };
        ResourceLocation texture = switch (((FishingBargeEntity)vesselEntity).getStatus()) {
            default -> throw new IncompatibleClassChangeError();
            case FishingBargeEntity.Status.STASHED -> this.getInsertTextureLocation();
            case FishingBargeEntity.Status.DEPLOYED -> this.deployedInsertTextureLocation;
            case FishingBargeEntity.Status.TRANSITION -> this.transitionInsertTextureLocation;
        };
        model.m_7695_(matrixStack, buffer.m_6299_(model.m_103119_(texture)), packedLight, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public EntityModel<T> getTransitionInsertModel() {
        return this.transitionInsertModel;
    }

    public EntityModel<T> getDeployedInsertModel() {
        return this.deployedInsertModel;
    }

    public ResourceLocation getTransitionInsertTextureLocation() {
        return this.transitionInsertTextureLocation;
    }

    public ResourceLocation getDeployedInsertTextureLocation() {
        return this.deployedInsertTextureLocation;
    }

    public static class Builder<T extends FishingBargeEntity>
    extends MultipartVesselRenderer.Builder<T> {
        private ModelPack<T> transitionInsertModelPack;
        private ModelPack<T> deployedInsertModelPack;

        public Builder(EntityRendererProvider.Context context) {
            super(context);
        }

        public Builder<T> transitionInsertModel(ModelSupplier<T> supplier, ModelLayerLocation location, ResourceLocation texture) {
            this.transitionInsertModelPack = new ModelPack<T>(supplier, location, texture);
            return this;
        }

        public Builder<T> deployedInsertModel(ModelSupplier<T> supplier, ModelLayerLocation location, ResourceLocation texture) {
            this.deployedInsertModelPack = new ModelPack<T>(supplier, location, texture);
            return this;
        }

        @Override
        public FishingBargeRenderer<T> build() {
            return new FishingBargeRenderer<T>(this.context, this.baseModelPack, this.insertModelPack, this.transitionInsertModelPack, this.deployedInsertModelPack, this.trimModelPack);
        }
    }
}

