/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.render.barge;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.murad.shipping.ShippingMod;
import dev.murad.shipping.entity.custom.vessel.VesselEntity;
import dev.murad.shipping.entity.models.vessel.EmptyModel;
import dev.murad.shipping.entity.render.ModelPack;
import dev.murad.shipping.entity.render.ModelSupplier;
import dev.murad.shipping.entity.render.barge.AbstractVesselRenderer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import org.jetbrains.annotations.NotNull;

public class MultipartVesselRenderer<T extends VesselEntity>
extends AbstractVesselRenderer<T> {
    private float rotation = 90.0f;
    private final EntityModel<T> baseModel;
    private final EntityModel<T> insertModel;
    private final EntityModel<T> trimModel;
    private final ResourceLocation baseTextureLocation;
    private final ResourceLocation insertTextureLocation;
    private final ResourceLocation trimTextureLocation;

    protected MultipartVesselRenderer(EntityRendererProvider.Context context, ModelPack<T> baseModelPack, ModelPack<T> insertModelPack, ModelPack<T> trimModelPack) {
        super(context);
        this.baseModel = baseModelPack.supplier().supply(context.m_174023_(baseModelPack.location()));
        this.baseTextureLocation = baseModelPack.texture();
        this.insertModel = insertModelPack.supplier().supply(context.m_174023_(insertModelPack.location()));
        this.insertTextureLocation = insertModelPack.texture();
        this.trimModel = trimModelPack.supplier().supply(context.m_174023_(trimModelPack.location()));
        this.trimTextureLocation = trimModelPack.texture();
    }

    @Override
    @Deprecated
    EntityModel<T> getModel(T entity) {
        return this.baseModel;
    }

    @Deprecated
    @NotNull
    public ResourceLocation getTextureLocation(@NotNull T pEntity) {
        return this.baseTextureLocation;
    }

    @Override
    protected void renderModel(T vesselEntity, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        int overlay = LivingEntityRenderer.m_115338_(vesselEntity, (float)0.0f);
        this.renderBaseModel(vesselEntity, matrixStack, buffer, packedLight, overlay);
        this.renderInsertModel(vesselEntity, matrixStack, buffer, packedLight, overlay);
        this.renderTrimModel(vesselEntity, matrixStack, buffer, packedLight, overlay);
    }

    protected void renderBaseModel(T vesselEntity, PoseStack matrixStack, MultiBufferSource buffer, int packedLight, int overlay) {
        this.baseModel.m_7695_(matrixStack, buffer.m_6299_(this.baseModel.m_103119_(this.baseTextureLocation)), packedLight, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected void renderInsertModel(T vesselEntity, PoseStack matrixStack, MultiBufferSource buffer, int packedLight, int overlay) {
        this.insertModel.m_7695_(matrixStack, buffer.m_6299_(this.insertModel.m_103119_(this.insertTextureLocation)), packedLight, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected void renderTrimModel(T vesselEntity, PoseStack matrixStack, MultiBufferSource buffer, int packedLight, int overlay) {
        Integer colorId = ((VesselEntity)vesselEntity).getColor();
        float[] color = (colorId == null ? DyeColor.RED : DyeColor.m_41053_((int)colorId)).m_41068_();
        this.trimModel.m_7695_(matrixStack, buffer.m_6299_(this.trimModel.m_103119_(this.trimTextureLocation)), packedLight, overlay, color[0], color[1], color[2], 1.0f);
    }

    public MultipartVesselRenderer<T> derotate() {
        this.rotation = 0.0f;
        return this;
    }

    @Override
    protected float getModelYrot() {
        return this.rotation;
    }

    public EntityModel<T> getBaseModel() {
        return this.baseModel;
    }

    public EntityModel<T> getInsertModel() {
        return this.insertModel;
    }

    public EntityModel<T> getTrimModel() {
        return this.trimModel;
    }

    public ResourceLocation getBaseTextureLocation() {
        return this.baseTextureLocation;
    }

    public ResourceLocation getInsertTextureLocation() {
        return this.insertTextureLocation;
    }

    public ResourceLocation getTrimTextureLocation() {
        return this.trimTextureLocation;
    }

    public static class Builder<T extends VesselEntity> {
        protected final EntityRendererProvider.Context context;
        protected ModelPack<T> baseModelPack;
        protected ModelPack<T> insertModelPack;
        protected ModelPack<T> trimModelPack;

        public Builder(EntityRendererProvider.Context context) {
            this.context = context;
        }

        public Builder<T> baseModel(ModelSupplier<T> supplier, ModelLayerLocation location, ResourceLocation texture) {
            this.baseModelPack = new ModelPack<T>(supplier, location, texture);
            return this;
        }

        public Builder<T> insertModel(ModelSupplier<T> supplier, ModelLayerLocation location, ResourceLocation texture) {
            this.insertModelPack = new ModelPack<T>(supplier, location, texture);
            return this;
        }

        public Builder<T> emptyInsert() {
            this.insertModel(EmptyModel::new, EmptyModel.LAYER_LOCATION, ShippingMod.entityTexture("emptytexture.png"));
            return this;
        }

        public Builder<T> trimModel(ModelSupplier<T> supplier, ModelLayerLocation location, ResourceLocation texture) {
            this.trimModelPack = new ModelPack<T>(supplier, location, texture);
            return this;
        }

        public MultipartVesselRenderer<T> build() {
            return new MultipartVesselRenderer<T>(this.context, this.baseModelPack, this.insertModelPack, this.trimModelPack);
        }
    }
}

