/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.event;

import dev.murad.shipping.ShippingConfig;
import dev.murad.shipping.entity.custom.vessel.tug.VehicleFrontPart;
import dev.murad.shipping.global.PlayerTrainChunkManager;
import dev.murad.shipping.global.TrainChunkManagerManager;
import dev.murad.shipping.item.SpringItem;
import dev.murad.shipping.util.LinkableEntity;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="littlelogistics")
public class ForgeEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void entityInteract(PlayerInteractEvent.EntityInteract event) {
        ForgeEventHandler.handleEvent((PlayerInteractEvent)event, event.getTarget());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void entitySpecificInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        ForgeEventHandler.handleEvent((PlayerInteractEvent)event, event.getTarget());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        Level level = event.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            TrainChunkManagerManager.get(serverLevel.m_7654_()).getManagers((ResourceKey<Level>)event.level.m_46472_()).forEach(PlayerTrainChunkManager::tick);
        }
    }

    @SubscribeEvent
    public static void onPlayerSignInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity().m_9236_().m_5776_() || ((Boolean)ShippingConfig.Server.OFFLINE_LOADING.get()).booleanValue()) {
            return;
        }
        TrainChunkManagerManager.get(event.getEntity().m_9236_().m_7654_()).getManagers(event.getEntity().m_20148_()).forEach(PlayerTrainChunkManager::activate);
    }

    @SubscribeEvent
    public static void onPlayerSignInEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getEntity().m_9236_().f_46443_ || ((Boolean)ShippingConfig.Server.OFFLINE_LOADING.get()).booleanValue()) {
            return;
        }
        TrainChunkManagerManager.get(event.getEntity().m_9236_().m_7654_()).getManagers(event.getEntity().m_20148_()).forEach(PlayerTrainChunkManager::deactivate);
    }

    private static void handleEvent(PlayerInteractEvent event, Entity target) {
        if (!event.getItemStack().m_41619_()) {
            Item item = event.getItemStack().m_41720_();
            if (item instanceof SpringItem) {
                SpringItem springItem = (SpringItem)item;
                if (target instanceof LinkableEntity || target instanceof VehicleFrontPart) {
                    springItem.onUsedOnEntity(event.getItemStack(), event.getEntity(), event.getLevel(), target);
                    event.setCanceled(true);
                    event.setCancellationResult(InteractionResult.SUCCESS);
                }
            }
            if (item instanceof ShearsItem && target instanceof LinkableEntity) {
                LinkableEntity v = (LinkableEntity)target;
                v.handleShearsCut();
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        }
    }
}

