/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.item.container;

import com.mojang.datafixers.util.Pair;
import dev.murad.shipping.item.container.TugRouteScreen;
import dev.murad.shipping.network.SetRouteTagPacket;
import dev.murad.shipping.network.TugRoutePacketHandler;
import dev.murad.shipping.util.TugRoute;
import dev.murad.shipping.util.TugRouteNode;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class TugRouteClientHandler {
    private static final Logger LOGGER = LogManager.getLogger(TugRouteClientHandler.class);
    private TugList widget;
    private TugRoute route;
    private boolean isOffHand;
    private Minecraft minecraft;
    private TugRouteScreen screen;

    public TugRouteClientHandler(TugRouteScreen screen, Minecraft minecraft, TugRoute route, boolean isOffHand) {
        this.route = route;
        this.isOffHand = isOffHand;
        this.screen = screen;
        this.minecraft = minecraft;
    }

    public TugList initializeWidget(int width, int height, int y0, int y1, int itemHeight) {
        this.widget = new TugList(this.minecraft, width, height, y0, y1, itemHeight);
        for (int i = 0; i < this.route.size(); ++i) {
            this.widget.add((TugRouteNode)this.route.get(i), i);
        }
        return this.widget;
    }

    public void deleteSelected() {
        TugList.Entry selected = (TugList.Entry)this.widget.m_93511_();
        if (selected != null) {
            int index = selected.index;
            this.route.remove(index);
            this.widget.m_6702_().remove(index);
            this.widget.m_6987_(null);
            this.markDirty();
        }
    }

    public void moveSelectedUp() {
        int index;
        TugList.Entry selected = (TugList.Entry)this.widget.m_93511_();
        if (selected != null && (index = selected.index) > 0) {
            TugRouteNode node = (TugRouteNode)this.route.remove(selected.index);
            this.widget.m_6702_().remove(index);
            this.route.add(index - 1, node);
            this.widget.m_6702_().add(index - 1, selected);
            this.markDirty();
        }
    }

    public void moveSelectedDown() {
        int index;
        TugList.Entry selected = (TugList.Entry)this.widget.m_93511_();
        if (selected != null && (index = selected.index) < this.route.size() - 1) {
            TugRouteNode node = (TugRouteNode)this.route.remove(selected.index);
            this.widget.m_6702_().remove(index);
            this.route.add(index + 1, node);
            this.widget.m_6702_().add(index + 1, selected);
            this.markDirty();
        }
    }

    public void renameSelected(@Nullable String name) {
        TugList.Entry selected = (TugList.Entry)this.widget.m_93511_();
        if (selected != null) {
            int index = selected.index;
            ((TugRouteNode)this.route.get(index)).setName(name);
            this.markDirty();
        }
    }

    public Optional<Pair<Integer, TugRouteNode>> getSelected() {
        TugList.Entry selected = (TugList.Entry)this.widget.m_93511_();
        if (selected != null) {
            int index = selected.index;
            return Optional.of(new Pair((Object)index, (Object)((TugRouteNode)this.route.get(index))));
        }
        return Optional.empty();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.widget.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    private void markDirty() {
        int i = 0;
        for (TugList.Entry entry : this.widget.m_6702_()) {
            entry.setIndex(i++);
        }
        TugRoutePacketHandler.INSTANCE.sendToServer((Object)new SetRouteTagPacket(this.route.hashCode(), this.isOffHand, this.route.toNBT()));
    }

    public final class TugList
    extends ObjectSelectionList<Entry> {
        public TugList(Minecraft minecraft, int width, int height, int y0, int y1, int itemHeight) {
            super(minecraft, width, height, y0, y1, itemHeight);
            this.m_93488_(false);
            this.m_93496_(false);
        }

        @NotNull
        public Optional<GuiEventListener> m_94729_(double p_212930_1_, double p_212930_3_) {
            return super.m_94729_(p_212930_1_, p_212930_3_);
        }

        public void m_88315_(@NotNull GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
            super.m_88315_(graphics, pMouseX, pMouseY, pPartialTick);
        }

        public void add(TugRouteNode node, int index) {
            this.m_7085_((AbstractSelectionList.Entry)new Entry(node, index));
        }

        public int m_5759_() {
            return TugRouteClientHandler.this.screen.getXSize() - 40;
        }

        protected int m_5756_() {
            return (this.f_93388_ + this.m_5759_()) / 2 + 5;
        }

        public class Entry
        extends ObjectSelectionList.Entry<Entry> {
            private TugRouteNode node;
            private int index;

            public Entry(TugRouteNode node, int index) {
                this.node = node;
                this.index = index;
            }

            public void m_6311_(GuiGraphics graphics, int ind, int rowTop, int rowLeft, int width, int height, int mouseX, int mouseY, boolean hovered, float partialTicks) {
                String s = this.node.getDisplayName(this.index) + ": " + this.node.getDisplayCoords();
                graphics.m_280218_(TugRouteScreen.GUI, rowLeft, rowTop, 0, hovered ? 216 : 236, width - 3, height);
                graphics.m_280488_(TugRouteClientHandler.this.screen.getFont(), s, rowLeft + 3, rowTop + 4, 0xFFFFFF);
            }

            public void setIndex(int index) {
                this.index = index;
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                if (button == 0) {
                    this.select();
                    return true;
                }
                return false;
            }

            private void select() {
                TugList.this.m_6987_((AbstractSelectionList.Entry)this);
            }

            @NotNull
            public Component m_142172_() {
                return Component.m_237113_((String)"");
            }
        }
    }
}

