/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.util;

import dev.murad.shipping.capability.StallingCapability;
import dev.murad.shipping.util.LinkableEntity;
import dev.murad.shipping.util.Train;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class LinkingHandler<T extends Entity> {
    private boolean waitForDominated = false;
    private final T entity;
    private final Class<T> clazz;
    public Optional<T> leader = Optional.empty();
    public Optional<T> follower = Optional.empty();
    public Train<T> train;
    @Nullable
    private CompoundTag dominantNBT;
    private final EntityDataAccessor<Integer> dominantID;
    private final EntityDataAccessor<Integer> dominatedID;

    public LinkingHandler(T entity, Class<T> clazz, EntityDataAccessor<Integer> dominantID, EntityDataAccessor<Integer> dominatedID) {
        this.entity = entity;
        this.clazz = clazz;
        this.dominantID = dominantID;
        this.dominatedID = dominatedID;
    }

    public void tickLoad() {
        if (this.entity.m_9236_().f_46443_) {
            this.fetchDominantClient();
            this.fetchDominatedClient();
        } else {
            if (this.leader.isEmpty() && this.dominantNBT != null) {
                this.tryToLoadFromNBT(this.dominantNBT).ifPresent(arg_0 -> LinkingHandler.lambda$tickLoad$0((LinkableEntity)this.entity, arg_0));
                this.leader.ifPresent(d -> {
                    ((LinkableEntity)d).setDominated(this.entity);
                    this.dominantNBT = null;
                });
            }
            if (this.follower.isPresent()) {
                this.waitForDominated = false;
                this.stallNonTicking();
            } else if (this.waitForDominated) {
                this.entity.getCapability(StallingCapability.STALLING_CAPABILITY).ifPresent(StallingCapability::stall);
            }
            this.entity.m_20088_().m_135381_(this.dominantID, (Object)this.leader.map(rec$ -> ((Entity)rec$).m_19879_()).orElse(-1));
            this.entity.m_20088_().m_135381_(this.dominatedID, (Object)this.follower.map(rec$ -> ((Entity)rec$).m_19879_()).orElse(-1));
        }
    }

    private void stallNonTicking() {
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        this.dominantNBT = compound.m_128469_("dominant");
        this.waitForDominated = compound.m_128471_("hasChild");
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        if (this.leader.isPresent()) {
            this.writeNBT((Entity)this.leader.get(), compound);
        } else if (this.dominantNBT != null) {
            compound.m_128365_(LinkableEntity.LinkSide.DOMINANT.name(), (Tag)this.dominantNBT);
        }
        compound.m_128379_("hasChild", this.follower.isPresent());
    }

    private void writeNBT(Entity entity, CompoundTag globalCompound) {
        CompoundTag compound = new CompoundTag();
        compound.m_128405_("X", (int)Math.floor(entity.m_20185_()));
        compound.m_128405_("Y", (int)Math.floor(entity.m_20186_()));
        compound.m_128405_("Z", (int)Math.floor(entity.m_20189_()));
        compound.m_128359_("UUID", entity.m_20148_().toString());
        globalCompound.m_128365_("dominant", (Tag)compound);
    }

    public static void defineSynchedData(Entity entity, EntityDataAccessor<Integer> dominantID, EntityDataAccessor<Integer> dominatedID) {
        entity.m_20088_().m_135372_(dominantID, (Object)-1);
        entity.m_20088_().m_135372_(dominatedID, (Object)-1);
    }

    public void onSyncedDataUpdated(@NotNull EntityDataAccessor<?> key) {
        if (this.entity.m_9236_().f_46443_ && (this.dominatedID.equals(key) || this.dominantID.equals(key))) {
            this.fetchDominantClient();
            this.fetchDominatedClient();
        }
    }

    private void fetchDominantClient() {
        Entity potential = this.entity.m_9236_().m_6815_(((Integer)this.entity.m_20088_().m_135370_(this.dominantID)).intValue());
        this.leader = this.clazz.isInstance(potential) ? Optional.of((Entity)this.clazz.cast(potential)) : Optional.empty();
    }

    private Optional<T> tryToLoadFromNBT(CompoundTag compound) {
        try {
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            pos.m_122178_(compound.m_128451_("X"), compound.m_128451_("Y"), compound.m_128451_("Z"));
            String uuid = compound.m_128461_("UUID");
            AABB searchBox = new AABB((double)(pos.m_123341_() - 2), (double)(pos.m_123342_() - 2), (double)(pos.m_123343_() - 2), (double)(pos.m_123341_() + 2), (double)(pos.m_123342_() + 2), (double)(pos.m_123343_() + 2));
            List entities = this.entity.m_9236_().m_6249_(this.entity, searchBox, e -> e.m_20149_().equals(uuid) && this.clazz.isInstance(e));
            return entities.stream().findFirst().map(e -> (Entity)this.clazz.cast(e));
        }
        catch (Exception e2) {
            return Optional.empty();
        }
    }

    private void fetchDominatedClient() {
        Entity potential = this.entity.m_9236_().m_6815_(((Integer)this.entity.m_20088_().m_135370_(this.dominatedID)).intValue());
        this.follower = this.clazz.isInstance(potential) ? Optional.of((Entity)this.clazz.cast(potential)) : Optional.empty();
    }

    private static /* synthetic */ void lambda$tickLoad$0(LinkableEntity rec$, Object x$0) {
        rec$.setDominant((LinkableEntity)x$0);
    }
}

