/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutilities.features.flatblocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockFlatTile
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty HIDDEN = BooleanProperty.m_61465_((String)"hidden");
    public static final BooleanProperty LOCKED = BooleanProperty.m_61465_((String)"locked");
    public static final BlockBehaviour.Properties BLOCK_PROPERTIES = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283875_).m_60913_(3.0f, 10.0f).m_60910_().m_60918_(SoundType.f_154679_);
    public static final VoxelShape BOUNDS = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private final CollisionEffect collisionEffect;

    public BlockFlatTile(CollisionEffect collisionEffect) {
        this(BLOCK_PROPERTIES, collisionEffect);
    }

    public BlockFlatTile(BlockBehaviour.Properties properties, CollisionEffect collisionEffect) {
        super(properties);
        this.collisionEffect = collisionEffect;
        BlockState defaultState = this.m_49966_();
        defaultState = (BlockState)defaultState.m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(false));
        defaultState = (BlockState)defaultState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false));
        defaultState = (BlockState)defaultState.m_61124_((Property)HIDDEN, (Comparable)Boolean.valueOf(false));
        defaultState = (BlockState)defaultState.m_61124_((Property)LOCKED, (Comparable)Boolean.valueOf(false));
        this.m_49959_(defaultState);
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (this.collisionEffect != null && !((Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_)).booleanValue() && entity.m_20186_() <= (double)pos.m_123342_() + 0.4) {
            this.collisionEffect.onCollision(state, world, pos, entity);
            if (((Boolean)state.m_61143_((Property)HIDDEN)).booleanValue()) {
                world.m_46796_(3002, pos, -1);
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)HIDDEN, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61448_, BlockStateProperties.f_61362_, HIDDEN, LOCKED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return BOUNDS;
    }

    public boolean m_48673_(BlockState state) {
        return true;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player.m_21120_(hand).m_150930_(Items.f_41978_)) {
            boolean oldValue = (Boolean)state.m_61143_((Property)LOCKED);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)LOCKED, (Comparable)Boolean.valueOf(!oldValue)), 2);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)(!oldValue ? DustParticleOptions.f_123656_ : ParticleTypes.f_123762_), (double)pos.m_123341_() + 0.5, (double)((float)pos.m_123342_() + 0.075f), (double)pos.m_123343_() + 0.5, 16, 0.25, 0.0, 0.25, 0.0);
                serverLevel.m_5594_(null, pos, SoundEvents.f_12088_, SoundSource.BLOCKS, 0.3f, !oldValue ? 0.6f : 0.5f);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, hand, hitResult);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            world.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return super.m_7417_(state, facing, facingState, world, currentPos, facingPos);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState preExistingFluidState = context.m_43725_().m_6425_(context.m_8083_());
        BlockState placedState = super.m_5573_(context);
        if (placedState != null) {
            placedState = (BlockState)placedState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(preExistingFluidState.m_192917_((Fluid)Fluids.f_76193_)));
            placedState = (BlockState)placedState.m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(context.m_43725_().m_276867_(context.m_8083_())));
        }
        return placedState;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!world.f_46443_ && !((Boolean)state.m_61143_((Property)LOCKED)).booleanValue()) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(world.m_276867_(pos))), 2);
        }
        super.m_6861_(state, world, pos, block, fromPos, isMoving);
    }

    @FunctionalInterface
    public static interface CollisionEffect {
        public void onCollision(BlockState var1, Level var2, BlockPos var3, Entity var4);
    }
}

