/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutilities.features.tomes;

import java.util.List;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.api.util.TextHelper;
import net.darkhax.darkutilities.features.tomes.ItemTome;
import net.darkhax.darkutilities.features.tomes.TomeEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;

public class ItemTomeFont
extends ItemTome {
    private final ResourceLocation fontId;
    private final Component fontPreview;

    public ItemTomeFont(ResourceLocation fontId) {
        super(null, ItemTomeFont.fontifyEntity(fontId), ItemTomeFont.fontifyBlock(fontId));
        this.fontId = fontId;
        this.fontPreview = TextHelper.applyFont((Component)Component.m_237115_((String)("font." + fontId.m_135827_() + "." + fontId.m_135815_() + ".preview")), (ResourceLocation)this.fontId);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        tooltip.add(this.fontPreview);
    }

    public static TomeEffect<BlockPos, InteractionResult> fontifyBlock(ResourceLocation fontId) {
        return (stack, player, hand, target) -> {
            BlockState block = player.m_9236_().m_8055_(target);
            BlockEntity blockEntity = player.m_9236_().m_7702_(target);
            if (blockEntity instanceof BaseContainerBlockEntity) {
                BaseContainerBlockEntity container = (BaseContainerBlockEntity)blockEntity;
                if (stack.m_41788_()) {
                    container.m_58638_(TextHelper.applyFont((Component)stack.m_41786_(), (ResourceLocation)fontId));
                    player.m_9236_().m_46796_(3002, target, -1);
                    return InteractionResult.SUCCESS;
                }
                container.m_58638_(TextHelper.applyFont((Component)container.m_5446_(), (ResourceLocation)fontId));
                player.m_9236_().m_46796_(3002, target, -1);
                return InteractionResult.SUCCESS;
            }
            if (blockEntity instanceof SignBlockEntity) {
                SignBlockEntity sign = (SignBlockEntity)blockEntity;
                sign.m_277073_(ItemTomeFont.applySignFont(fontId), true);
                sign.m_277073_(ItemTomeFont.applySignFont(fontId), false);
                sign.m_58904_().m_7260_(sign.m_58899_(), sign.m_58900_(), sign.m_58900_(), 3);
                player.m_9236_().m_46796_(3002, target, -1);
            }
            return null;
        };
    }

    private static UnaryOperator<SignText> applySignFont(ResourceLocation fontId) {
        return text -> {
            SignText newText = text;
            for (int i = 0; i < 4; ++i) {
                Component lineText = text.m_277138_(i, false);
                if (lineText.m_214077_() == ComponentContents.f_237124_) continue;
                newText = newText.m_276913_(i, TextHelper.applyFont((Component)lineText.m_6881_(), (ResourceLocation)fontId));
            }
            return newText;
        };
    }

    public static TomeEffect<Entity, InteractionResult> fontifyEntity(ResourceLocation fontId) {
        return (stack, player, hand, target) -> {
            if (stack.m_41788_()) {
                target.m_6593_(TextHelper.applyFont((Component)stack.m_41786_(), (ResourceLocation)fontId));
                return InteractionResult.SUCCESS;
            }
            if (target.m_8077_()) {
                target.m_6593_(TextHelper.applyFont((Component)target.m_7770_(), (ResourceLocation)fontId));
                return InteractionResult.SUCCESS;
            }
            return null;
        };
    }
}

