/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.client.gui;

import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.client.gui.implementations.UpgradeableScreen;
import appeng.client.gui.style.Blitter;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.ProgressBar;
import appeng.client.gui.widgets.ServerSettingToggleButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.core.localization.Tooltips;
import appeng.menu.implementations.UpgradeableMenu;
import appeng.menu.interfaces.IProgressProvider;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.fluids.FluidStack;
import net.pedroksl.advanced_ae.api.IFluidTankScreen;
import net.pedroksl.advanced_ae.client.gui.widgets.AAEActionButton;
import net.pedroksl.advanced_ae.client.gui.widgets.AAEActionItems;
import net.pedroksl.advanced_ae.client.gui.widgets.AAEToolbarActionButton;
import net.pedroksl.advanced_ae.client.gui.widgets.FluidTankSlot;
import net.pedroksl.advanced_ae.common.definitions.AAEText;
import net.pedroksl.advanced_ae.gui.ReactionChamberMenu;

public class ReactionChamberScreen
extends UpgradeableScreen<ReactionChamberMenu>
implements IFluidTankScreen {
    private static final int INPUT_TANK_X = 9;
    private static final int OUTPUT_TANK_X = 151;
    private static final int TANKS_Y = 21;
    private static final int TANKS_WIDTH = 16;
    private static final int TANKS_HEIGHT = 58;
    private final ProgressBar pb;
    private final SettingToggleButton<YesNo> autoExportBtn;
    private final AAEToolbarActionButton outputConfigure;
    private final AlertWidget powerAlert;
    private FluidTankSlot inputSlot;
    private FluidTankSlot outputSlot;

    public ReactionChamberScreen(ReactionChamberMenu menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super((UpgradeableMenu)menu, playerInventory, title, style);
        this.pb = new ProgressBar((IProgressProvider)this.f_97732_, style.getImage("progressBar"), ProgressBar.Direction.VERTICAL);
        this.widgets.add("progressBar", (AbstractWidget)this.pb);
        this.autoExportBtn = new ServerSettingToggleButton(Settings.AUTO_EXPORT, (Enum)YesNo.NO);
        this.addToLeftToolbar((Button)this.autoExportBtn);
        this.outputConfigure = new AAEToolbarActionButton(AAEActionItems.DIRECTIONAL_OUTPUT, btn -> menu.configureOutput());
        this.outputConfigure.setVisibility(((ReactionChamberMenu)this.m_6262_()).getAutoExport() == YesNo.YES);
        this.addToLeftToolbar(this.outputConfigure);
        AAEActionButton clearBtn = new AAEActionButton(AAEActionItems.F_FLUSH, btn -> menu.clearFluid());
        clearBtn.setHalfSize(true);
        clearBtn.setDisableBackground(true);
        this.widgets.add("clearFluid", (AbstractWidget)clearBtn);
        AAEActionButton clearOutBtn = new AAEActionButton(AAEActionItems.F_FLUSH, btn -> menu.clearFluidOut());
        clearOutBtn.setHalfSize(true);
        clearOutBtn.setDisableBackground(true);
        this.widgets.add("clearFluidOut", (AbstractWidget)clearOutBtn);
        this.powerAlert = new AlertWidget(style.getImage("powerAlert"));
        this.powerAlert.m_257544_(Tooltip.m_257550_((Component)Tooltips.of((Component[])new Component[]{AAEText.InsufficientPower.text().m_130948_(Tooltips.RED), Component.m_237113_((String)"\n").m_7220_((Component)AAEText.InsufficientPowerDetails.text()).m_130948_(Tooltips.NORMAL_TOOLTIP_TEXT)})));
        this.widgets.add("powerAlert", (AbstractWidget)this.powerAlert);
    }

    protected void m_7856_() {
        Objects.requireNonNull((ReactionChamberMenu)this.f_97732_);
        this.inputSlot = (FluidTankSlot)this.m_142416_((GuiEventListener)new FluidTankSlot((AbstractContainerScreen<?>)this, 1, this.f_97735_ + 9, this.f_97736_ + 21, 16, 58, 16, (Component)Component.m_237119_()));
        Objects.requireNonNull((ReactionChamberMenu)this.f_97732_);
        this.outputSlot = (FluidTankSlot)this.m_142416_((GuiEventListener)new FluidTankSlot((AbstractContainerScreen<?>)this, 0, this.f_97735_ + 151, this.f_97736_ + 21, 16, 58, 16, (Component)Component.m_237119_()));
        super.m_7856_();
    }

    protected void updateBeforeRender() {
        super.updateBeforeRender();
        int progress = ((ReactionChamberMenu)this.f_97732_).getCurrentProgress() * 100 / ((ReactionChamberMenu)this.f_97732_).getMaxProgress();
        this.pb.setFullMsg((Component)Component.m_237113_((String)(progress + "%")));
        this.autoExportBtn.set((Enum)((ReactionChamberMenu)this.m_6262_()).getAutoExport());
        this.outputConfigure.setVisibility(((ReactionChamberMenu)this.m_6262_()).getAutoExport() == YesNo.YES);
        this.inputSlot.m_264152_(this.f_97735_ + 9, this.f_97736_ + 21);
        this.outputSlot.m_264152_(this.f_97735_ + 151, this.f_97736_ + 21);
        this.powerAlert.f_93624_ = ((ReactionChamberMenu)this.m_6262_()).getShowWarning();
    }

    public void updateFluidTankContents(FluidStack inputFluid, FluidStack outputFluid) {
        this.inputSlot.setFluidStack(inputFluid);
        this.outputSlot.setFluidStack(outputFluid);
    }

    @Override
    public void playSoundFeedback(boolean isInsert) {
        this.inputSlot.playDownSound(Minecraft.m_91087_().m_91106_(), isInsert);
    }

    private static class AlertWidget
    extends AbstractWidget {
        private final Blitter powerAlert;

        public AlertWidget(Blitter powerAlert) {
            super(0, 0, 18, 18, (Component)Component.m_237119_());
            this.powerAlert = powerAlert;
        }

        protected void m_87963_(GuiGraphics guiGraphics, int i, int i1, float v) {
            this.powerAlert.dest(this.m_252754_(), this.m_252907_()).blit(guiGraphics);
        }

        protected void m_168797_(NarrationElementOutput narrationElementOutput) {
        }
    }
}

