/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.parts;

import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.orientation.BlockOrientation;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AmountFormat;
import appeng.api.util.AEColor;
import appeng.client.render.BlockEntityRenderHelper;
import appeng.core.AppEng;
import appeng.hooks.ticking.TickHandler;
import appeng.items.parts.PartModels;
import appeng.parts.PartModel;
import appeng.parts.reporting.AbstractMonitorPart;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.pedroksl.advanced_ae.client.renderer.AAEBlockEntityRenderHelper;
import net.pedroksl.advanced_ae.common.definitions.AAEConfig;
import net.pedroksl.advanced_ae.common.definitions.AAEItems;
import net.pedroksl.advanced_ae.common.definitions.AAEText;
import net.pedroksl.advanced_ae.common.logic.ThroughputCache;

public class ThroughputMonitorPart
extends AbstractMonitorPart
implements IGridTickable {
    @PartModels
    public static final ResourceLocation MODEL_OFF = AppEng.makeId((String)"part/storage_monitor_off");
    @PartModels
    public static final ResourceLocation MODEL_ON = AppEng.makeId((String)"part/storage_monitor_on");
    @PartModels
    public static final ResourceLocation MODEL_LOCKED_OFF = AppEng.makeId((String)"part/storage_monitor_locked_off");
    @PartModels
    public static final ResourceLocation MODEL_LOCKED_ON = AppEng.makeId((String)"part/storage_monitor_locked_on");
    public static final IPartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_OFF, MODEL_STATUS_OFF});
    public static final IPartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_ON, MODEL_STATUS_ON});
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_ON, MODEL_STATUS_HAS_CHANNEL});
    public static final IPartModel MODELS_LOCKED_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_LOCKED_OFF, MODEL_STATUS_OFF});
    public static final IPartModel MODELS_LOCKED_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_LOCKED_ON, MODEL_STATUS_ON});
    public static final IPartModel MODELS_LOCKED_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_LOCKED_ON, MODEL_STATUS_HAS_CHANNEL});
    private final ThroughputCache cache = new ThroughputCache();
    protected long lastReportedValue = -1L;
    protected String lastHumanReadableValue = "";
    private WorkRoutine workRoutine = WorkRoutine.SECOND;
    private WorkRoutine lastWorkRoutine = WorkRoutine.SECOND;
    private static final int positiveColor = AEColor.GREEN.mediumVariant;
    private static final int negativeColor = AEColor.RED.mediumVariant;

    public ThroughputMonitorPart(IPartItem<?> partItem) {
        super(partItem, false);
        this.getMainNode().addService(IGridTickable.class, (IGridNodeService)this);
    }

    public void writeToNBT(CompoundTag data) {
        super.writeToNBT(data);
        data.m_128359_("throughput", this.lastHumanReadableValue);
        data.m_128405_("routine", this.workRoutine.ordinal());
    }

    public void readFromNBT(CompoundTag data) {
        super.readFromNBT(data);
        this.lastHumanReadableValue = data.m_128461_("throughput");
        this.workRoutine = WorkRoutine.fromInt(data.m_128451_("routine"));
    }

    public void writeToStream(FriendlyByteBuf data) {
        super.writeToStream(data);
        data.writeLong(this.lastReportedValue);
        data.m_130070_(this.lastHumanReadableValue);
        data.m_130068_((Enum)this.workRoutine);
    }

    public boolean readFromStream(FriendlyByteBuf data) {
        boolean needRedraw = super.readFromStream(data);
        long reportedValue = data.readLong();
        needRedraw |= reportedValue != this.lastReportedValue;
        this.lastReportedValue = reportedValue;
        this.lastHumanReadableValue = data.m_130277_();
        WorkRoutine routine = (WorkRoutine)data.m_130066_(WorkRoutine.class);
        boolean bl = this.workRoutine != routine;
        this.workRoutine = routine;
        return needRedraw |= bl;
    }

    public void writeVisualStateToNBT(CompoundTag data) {
        super.writeVisualStateToNBT(data);
        data.m_128356_("lastValue", this.lastReportedValue);
        data.m_128359_("throughput", this.lastHumanReadableValue);
        data.m_128405_("routine", this.workRoutine.ordinal());
    }

    public void readVisualStateFromNBT(CompoundTag data) {
        super.readVisualStateFromNBT(data);
        this.lastReportedValue = data.m_128454_("lastValue");
        this.lastHumanReadableValue = data.m_128461_("throughput");
        this.workRoutine = WorkRoutine.fromInt(data.m_128451_("routine"));
    }

    public boolean onPartActivate(Player player, InteractionHand hand, Vec3 pos) {
        ItemStack heldItem;
        if (!this.isClientSide() && (heldItem = player.m_21120_(hand)).m_150930_(AAEItems.MONITOR_CONFIGURATOR.m_5456_())) {
            this.cycleWorkRoutine();
            return true;
        }
        return super.onPartActivate(player, hand, pos);
    }

    private void cycleWorkRoutine() {
        this.workRoutine = WorkRoutine.cycle(this.workRoutine);
        this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().alertDevice(node));
    }

    protected void configureWatchers() {
        if (this.getDisplayed() != null) {
            this.updateState(this.getAmount(), TickHandler.instance().getCurrentTick());
            this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice(node));
        } else {
            this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().sleepDevice(node));
        }
        super.configureWatchers();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderDynamic(float partialTicks, PoseStack poseStack, MultiBufferSource buffers, int combinedLightIn, int combinedOverlayIn) {
        if (this.isActive() && this.getDisplayed() != null) {
            MutableComponent text;
            poseStack.m_85836_();
            BlockOrientation orientation = BlockOrientation.get((Direction)this.getSide(), (int)this.getSpin());
            poseStack.m_85837_(0.5, 0.5, 0.5);
            BlockEntityRenderHelper.rotateToFace((PoseStack)poseStack, (BlockOrientation)orientation);
            poseStack.m_85837_(0.0, 0.1, 0.5);
            BlockEntityRenderHelper.renderItem2dWithAmount((PoseStack)poseStack, (MultiBufferSource)buffers, (AEKey)this.getDisplayed(), (long)this.getAmount(), (boolean)this.canCraft(), (float)0.3f, (float)-0.15f, (int)this.getColor().contrastTextColor, (Level)this.getLevel());
            poseStack.m_252880_(0.0f, -0.23f, 0.0f);
            String sign = this.lastReportedValue > 0L ? "+" : (this.lastReportedValue == 0L ? "" : "-");
            switch (this.workRoutine) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case TICK: {
                    MutableComponent mutableComponent = AAEText.OverdriveThroughputMonitorValue.text(new Object[]{sign, this.lastHumanReadableValue});
                    break;
                }
                case SECOND: {
                    MutableComponent mutableComponent = AAEText.ThroughputMonitorValue.text(new Object[]{sign, this.lastHumanReadableValue});
                    break;
                }
                case MINUTE: {
                    MutableComponent mutableComponent = AAEText.SlowThroughputMonitorValue.text(new Object[]{sign, this.lastHumanReadableValue});
                    break;
                }
                case TEN_MINUTE: {
                    MutableComponent mutableComponent = text = AAEText.SlowerThroughputMonitorValue.text(new Object[]{sign, this.lastHumanReadableValue});
                }
            }
            int color = this.lastReportedValue > 0L ? positiveColor : (this.lastReportedValue == 0L ? this.getColor().contrastTextColor : negativeColor);
            AAEBlockEntityRenderHelper.renderString(poseStack, buffers, (Component)text, color);
            poseStack.m_85849_();
        }
    }

    public IPartModel getStaticModels() {
        return this.selectModel(MODELS_OFF, MODELS_ON, MODELS_HAS_CHANNEL, MODELS_LOCKED_OFF, MODELS_LOCKED_ON, MODELS_LOCKED_HAS_CHANNEL);
    }

    protected void onMainNodeStateChanged(IGridNodeListener.State reason) {
        this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice(node));
        super.onMainNodeStateChanged(reason);
    }

    public TickingRequest getTickingRequest(IGridNode iGridNode) {
        return new TickingRequest(20, 100, !this.isActive() || this.getDisplayed() == null, true);
    }

    public TickRateModulation tickingRequest(IGridNode iGridNode, int i) {
        if (!this.getMainNode().isActive() || this.getDisplayed() == null) {
            this.resetState();
            return TickRateModulation.SLEEP;
        }
        long currentTick = TickHandler.instance().getCurrentTick();
        long currentAmount = this.getAmount();
        if (this.cache.size() == 0) {
            this.updateState(currentAmount, currentTick);
            this.lastHumanReadableValue = "-";
            return TickRateModulation.URGENT;
        }
        if (this.workRoutine == this.lastWorkRoutine) {
            long amountPerTick = this.cache.averagePerTick(this.workRoutine.timeLimit_s);
            this.lastReportedValue = Math.round(amountPerTick * (long)this.workRoutine.ticks);
            this.lastHumanReadableValue = this.getDisplayed().formatAmount(Math.abs(this.lastReportedValue), AmountFormat.SLOT);
        } else {
            this.lastHumanReadableValue = "";
        }
        this.updateState(currentAmount, currentTick);
        this.getHost().markForUpdate();
        return TickRateModulation.SLOWER;
    }

    private void resetState() {
        this.cache.clear();
        this.lastHumanReadableValue = "";
    }

    private void updateState(long amount, long tick) {
        this.cache.push(amount, tick);
        this.lastWorkRoutine = this.workRoutine;
    }

    private static enum WorkRoutine {
        TICK(1, 5),
        SECOND(20, 20),
        MINUTE(1200, AAEConfig.instance().getThroughputMonitorCacheSize() / 2),
        TEN_MINUTE(12000, AAEConfig.instance().getThroughputMonitorCacheSize() * 5);

        public final int ticks;
        public final int timeLimit_s;

        public static WorkRoutine cycle(WorkRoutine routine) {
            return switch (routine) {
                default -> throw new IncompatibleClassChangeError();
                case TICK -> SECOND;
                case SECOND -> MINUTE;
                case MINUTE -> TEN_MINUTE;
                case TEN_MINUTE -> TICK;
            };
        }

        public static WorkRoutine fromInt(int value) {
            return switch (value) {
                case 0 -> TICK;
                case 2 -> MINUTE;
                case 3 -> TEN_MINUTE;
                default -> SECOND;
            };
        }

        private WorkRoutine(int ticks, int timeLimit_s) {
            this.ticks = ticks;
            this.timeLimit_s = timeLimit_s;
        }
    }
}

