/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.network.packet.quantumarmor;

import appeng.api.stacks.GenericStack;
import com.glodblock.github.glodium.network.packet.IMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.pedroksl.advanced_ae.gui.QuantumArmorConfigMenu;

public class QuantumArmorMagnetPacket
implements IMessage<QuantumArmorMagnetPacket> {
    private int currentValue;
    private List<GenericStack> filter;
    private boolean blacklist;

    public QuantumArmorMagnetPacket() {
    }

    public QuantumArmorMagnetPacket(int currentValue, List<GenericStack> filter, boolean blacklist) {
        this.currentValue = currentValue;
        this.filter = filter;
        this.blacklist = blacklist;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.currentValue);
        buf.writeInt(this.filter.size());
        for (GenericStack genericStack : this.filter) {
            GenericStack.writeBuffer((GenericStack)genericStack, (FriendlyByteBuf)buf);
        }
        buf.writeBoolean(this.blacklist);
    }

    public void fromBytes(FriendlyByteBuf buf) {
        this.currentValue = buf.readInt();
        int size = buf.readInt();
        ArrayList<GenericStack> list = new ArrayList<GenericStack>();
        for (int i = 0; i < size; ++i) {
            list.add(GenericStack.readBuffer((FriendlyByteBuf)buf));
        }
        this.filter = list;
        this.blacklist = buf.readBoolean();
    }

    public void onMessage(Player serverPlayer) {
        AbstractContainerMenu abstractContainerMenu = serverPlayer.f_36096_;
        if (abstractContainerMenu instanceof QuantumArmorConfigMenu) {
            QuantumArmorConfigMenu menu = (QuantumArmorConfigMenu)abstractContainerMenu;
            menu.openMagnetScreen(this.currentValue, this.filter, this.blacklist);
        }
    }

    public Class<QuantumArmorMagnetPacket> getPacketClass() {
        return QuantumArmorMagnetPacket.class;
    }

    public boolean isClient() {
        return false;
    }
}

