/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.noflyzone.util;

import cy.jdkdigital.noflyzone.Config;
import cy.jdkdigital.noflyzone.NoFlyZone;
import cy.jdkdigital.noflyzone.network.PacketHandler;
import cy.jdkdigital.noflyzone.util.CompatHandler;
import cy.jdkdigital.noflyzone.util.compat.GameStagesCompat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;

public class FlightHelper {
    static Map<UUID, Map<BlockPos, Boolean>> cache = new HashMap<UUID, Map<BlockPos, Boolean>>();
    static List<ResourceKey<Structure>> cachedStructureResourceKeys = new ArrayList<ResourceKey<Structure>>();
    static Map<UUID, List<Integer>> repeatCheck = new HashMap<UUID, List<Integer>>();
    static Map<UUID, Integer> lastNotified = new HashMap<UUID, Integer>();

    public static boolean isAllowedToFly(Player player) {
        if (player.m_7500_() || player.m_5833_()) {
            return true;
        }
        if (!cache.containsKey(player.m_20148_()) || cache.get(player.m_20148_()).size() > 10000) {
            cache.put(player.m_20148_(), new HashMap());
        }
        if (cache.get(player.m_20148_()).containsKey(player.m_20183_())) {
            return cache.get(player.m_20148_()).get(player.m_20183_());
        }
        boolean isAllowed = FlightHelper.isAllowedDimension(player) && FlightHelper.isAllowedBiome(player) && FlightHelper.isAllowedStructure(player);
        cache.get(player.m_20148_()).put(player.m_20183_(), isAllowed);
        return isAllowed;
    }

    private static boolean isAllowedDimension(Player player) {
        if (!Config.dimensions.isEmpty() && Config.dimensions.contains(player.m_9236_().m_46472_())) {
            String stage;
            if (ModList.get().isLoaded("gamestages") && Config.dimensionUnlocks.containsKey(player.m_9236_().m_46472_()) && GameStagesCompat.stageExists(stage = Config.dimensionUnlocks.get(player.m_9236_().m_46472_()))) {
                return GameStagesCompat.hasUnlockedStage(player, stage);
            }
            return false;
        }
        return true;
    }

    private static boolean isAllowedBiome(Player player) {
        if (Config.enableBiomeCheck) {
            String stage;
            Holder biome = player.m_9236_().m_204166_(player.m_20183_());
            if (ModList.get().isLoaded("gamestages") && biome.m_203543_().isPresent() && Config.biomeUnlocks.containsKey(biome.m_203543_().get()) && GameStagesCompat.stageExists(stage = Config.biomeUnlocks.get(biome.m_203543_().get()))) {
                return GameStagesCompat.hasUnlockedStage(player, stage);
            }
            return !biome.m_203656_(NoFlyZone.BIOME_BLACKLIST);
        }
        return true;
    }

    private static boolean isAllowedStructure(Player player) {
        Object object;
        if (Config.enableStructureCheck && (object = player.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)object;
            for (ResourceKey resourceKey : FlightHelper.getBlacklistedStructures(serverLevel)) {
                String stage;
                if (ModList.get().isLoaded("gamestages") && Config.structureUnlocks.containsKey(resourceKey) && GameStagesCompat.stageExists(stage = Config.structureUnlocks.get(resourceKey))) {
                    return GameStagesCompat.hasUnlockedStage(player, stage);
                }
                StructureStart test = serverLevel.m_215010_().m_220488_(player.m_20183_(), resourceKey);
                if (!test.m_73603_()) continue;
                return false;
            }
        }
        return true;
    }

    private static List<ResourceKey<Structure>> getBlacklistedStructures(ServerLevel level) {
        if (cachedStructureResourceKeys.isEmpty()) {
            Registry structureRegistry = level.m_9598_().m_175515_(Registries.f_256944_);
            structureRegistry.m_203431_(NoFlyZone.STRUCTURE_BLACKLIST).ifPresent(holders -> {
                cachedStructureResourceKeys = holders.m_203614_().map(structureHolder -> structureRegistry.m_7854_((Object)((Structure)structureHolder.get())).orElse(null)).filter(Objects::nonNull).toList();
            });
        }
        return cachedStructureResourceKeys;
    }

    public static void stopFlying(final Player player) {
        player.m_150110_().f_35935_ = false;
        if (!Config.allowElytraFlight && player.m_21255_()) {
            player.m_36321_();
        }
        if (!Config.allowFlyingDevices && CompatHandler.isUsingFlyingDevice(player)) {
            CompatHandler.disableFlyingDevice(player);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (Config.enableSlowFall) {
                boolean isHighUp;
                boolean bl = isHighUp = BlockPos.m_121990_((BlockPos)player.m_20183_(), (BlockPos)player.m_20183_().m_6625_(10)).filter(blockPos -> !player.m_9236_().m_8055_(blockPos).m_60795_()).count() == 0L;
                if (isHighUp) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 60));
                }
            }
            PacketHandler.sendStopFlightToPlayer(serverPlayer);
        }
        FlightHelper.sendFlightNotice(player);
        if (Config.enablePunishOffenders) {
            if (repeatCheck.containsKey(player.m_20148_())) {
                List<Integer> entries = repeatCheck.get(player.m_20148_());
                entries.add(player.f_19797_);
                if (entries.size() > Config.zapInterval / Config.checkInterval * 10) {
                    LightningBolt lightningbolt;
                    if (player.f_19797_ - entries.get(0) < 1000 && (lightningbolt = (LightningBolt)EntityType.f_20465_.m_20615_(player.m_9236_())) != null) {
                        lightningbolt.m_20219_(Vec3.m_82539_((Vec3i)player.m_20183_()));
                        lightningbolt.m_20874_(false);
                        player.m_9236_().m_7967_((Entity)lightningbolt);
                    }
                    repeatCheck.put(player.m_20148_(), new ArrayList());
                }
            } else {
                repeatCheck.put(player.m_20148_(), (List<Integer>)new ArrayList<Integer>(){
                    {
                        this.add(player.f_19797_);
                    }
                });
            }
        }
    }

    public static void sendFlightNotice(Player player) {
        if (!player.m_9236_().f_46443_) {
            if (!lastNotified.containsKey(player.m_20148_()) || lastNotified.get(player.m_20148_()) < player.f_19797_ - 60) {
                player.m_5661_((Component)Component.m_237115_((String)"noflightzone.disallowed_flightzone"), false);
            }
            lastNotified.put(player.m_20148_(), player.f_19797_);
        }
    }

    public static void sendTeleportNotice(Player player) {
        if (!player.m_9236_().f_46443_) {
            player.m_5661_((Component)Component.m_237115_((String)"noflightzone.disallowed_teleport"), false);
        }
    }

    public static boolean isFlying(Player player) {
        return player.m_150110_().f_35935_ || !Config.allowElytraFlight && player.m_21255_() || !Config.allowFlyingDevices && CompatHandler.isUsingFlyingDevice(player);
    }
}

