/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen;

import it.zerono.mods.extremereactors.CommonLocations;
import it.zerono.mods.extremereactors.gamecontent.compat.jei.IExtremeReactorsJeiService;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.GuiTheme;
import it.zerono.mods.zerocore.base.client.screen.control.MachineStatusIndicator;
import it.zerono.mods.zerocore.base.multiblock.client.screen.AbstractMultiblockScreen;
import it.zerono.mods.zerocore.base.multiblock.part.AbstractMultiblockEntity;
import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.control.Panel;
import it.zerono.mods.zerocore.lib.client.gui.control.SlotsGroup;
import it.zerono.mods.zerocore.lib.client.gui.layout.FixedLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.HorizontalAlignment;
import it.zerono.mods.zerocore.lib.client.gui.layout.ILayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.VerticalAlignment;
import it.zerono.mods.zerocore.lib.client.gui.layout.VerticalLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.client.gui.sprite.SpriteTextureMap;
import it.zerono.mods.zerocore.lib.item.inventory.PlayerInventoryUsage;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModTileContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.BooleanData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IBindableData;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.AbstractCuboidMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.variant.IMultiblockVariant;
import it.zerono.mods.zerocore.lib.text.TextHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.common.util.NonNullSupplier;
import org.jetbrains.annotations.Nullable;

public abstract class CommonMultiblockScreen<Controller extends AbstractCuboidMultiblockController<Controller>, T extends AbstractMultiblockEntity<Controller>, C extends ModTileContainer<T>>
extends AbstractMultiblockScreen<Controller, T, C> {
    public static final MutableComponent EMPTY_VALUE = TextHelper.translatable((String)"gui.zerocore.base.generic.empty");
    private final MachineStatusIndicator _indicator;

    protected CommonMultiblockScreen(C container, Inventory inventory, PlayerInventoryUsage inventoryUsage, Component title, NonNullSupplier<SpriteTextureMap> mainTextureSupplier) {
        super(container, inventory, inventoryUsage, title, mainTextureSupplier);
        this._indicator = this.createStatusIndicator(container);
        this.initialize();
    }

    protected CommonMultiblockScreen(C container, Inventory inventory, PlayerInventoryUsage inventoryUsage, Component title, int guiWidth, int guiHeight, NonNullSupplier<SpriteTextureMap> mainTextureSupplier) {
        super(container, inventory, inventoryUsage, title, guiWidth, guiHeight, mainTextureSupplier);
        this._indicator = this.createStatusIndicator(container);
        this.initialize();
    }

    protected CommonMultiblockScreen(C container, Inventory inventory, PlayerInventoryUsage inventoryUsage, Component title, int guiWidth, int guiHeight, SpriteTextureMap mainTexture) {
        super(container, inventory, inventoryUsage, title, guiWidth, guiHeight, mainTexture);
        this._indicator = this.createStatusIndicator(container);
        this.initialize();
    }

    protected abstract MachineStatusIndicator createStatusIndicator(C var1);

    protected MachineStatusIndicator createDefaultStatusIndicator(BooleanData bindableStatus, String activeTooltipKey, String inactiveTooltipKey) {
        MachineStatusIndicator indicator = new MachineStatusIndicator((ModContainerScreen)this, "indicator", (IBindableData)bindableStatus);
        indicator.setTooltips(true, activeTooltipKey);
        indicator.setTooltips(false, inactiveTooltipKey);
        return indicator;
    }

    protected MachineStatusIndicator createReactorStatusIndicator(BooleanData bindableStatus) {
        return this.createDefaultStatusIndicator(bindableStatus, "gui.bigreactors.reactor.active", "gui.bigreactors.reactor.inactive");
    }

    protected MachineStatusIndicator createTurbineStatusIndicator(BooleanData bindableStatus) {
        return this.createDefaultStatusIndicator(bindableStatus, "gui.bigreactors.turbine.active", "gui.bigreactors.turbine.inactive");
    }

    protected MachineStatusIndicator createReprocessorStatusIndicator(BooleanData bindableStatus) {
        return this.createDefaultStatusIndicator(bindableStatus, "gui.bigreactors.reprocessor.active", "gui.bigreactors.reprocessor.inactive");
    }

    protected MachineStatusIndicator createFluidizerStatusIndicator(BooleanData bindableStatus) {
        return this.createDefaultStatusIndicator(bindableStatus, "gui.bigreactors.fluidizer.active", "gui.bigreactors.fluidizer.inactive");
    }

    protected MachineStatusIndicator createEnergizerStatusIndicator(BooleanData bindableStatus) {
        return this.createDefaultStatusIndicator(bindableStatus, "gui.bigreactors.energizer.active", "gui.bigreactors.energizer.inactive");
    }

    protected void displayFluidizerRecipes() {
        ((IExtremeReactorsJeiService)IExtremeReactorsJeiService.SERVICE.get()).displayFluidizerRecipes();
    }

    protected void displayReprocessorRecipes() {
        ((IExtremeReactorsJeiService)IExtremeReactorsJeiService.SERVICE.get()).displayReprocessorRecipes();
    }

    protected void displayReactorRecipes() {
        ((IExtremeReactorsJeiService)IExtremeReactorsJeiService.SERVICE.get()).displayReactorRecipes();
    }

    protected static NonNullSupplier<SpriteTextureMap> mainTextureFromVariant(IMultiblockVariant variant) {
        return () -> new SpriteTextureMap(CommonLocations.TEXTURES_GUI_MULTIBLOCK.buildWithSuffix(variant.getName() + "_background.png"), 256, 256);
    }

    protected static NonNullSupplier<SpriteTextureMap> halfTextureFromVariant(IMultiblockVariant variant) {
        return () -> new SpriteTextureMap(CommonLocations.TEXTURES_GUI_MULTIBLOCK.buildWithSuffix(variant.getName() + "_background_half.png"), 256, 98);
    }

    protected Panel createSingleIoSlotPanel(String groupName, String invName, int x, int y, NonNullSupplier<ISprite> slotBackground) {
        SlotsGroup sg = this.createSingleSlotGroupControl(groupName, invName);
        sg.setLayoutEngineHint(FixedLayoutEngine.hint((int)10, (int)10, (int)18, (int)18));
        Panel background = new Panel((ModContainerScreen)this, "background");
        background.setBackground((ISprite)slotBackground.get());
        background.setDesiredDimension(38, 38);
        background.setLayoutEngine((ILayoutEngine)new FixedLayoutEngine().setZeroMargins());
        background.addControl((IControl)sg);
        Panel outer = new Panel((ModContainerScreen)this, "ioSlot");
        outer.setDesiredDimension(162, 48);
        outer.setLayoutEngine((ILayoutEngine)((VerticalLayoutEngine)((VerticalLayoutEngine)new VerticalLayoutEngine().setZeroMargins()).setHorizontalAlignment(HorizontalAlignment.Center)).setVerticalAlignment(VerticalAlignment.Center));
        outer.addControl((IControl)background);
        return outer;
    }

    @Nullable
    protected IControl getTitleBarWidget() {
        return this._indicator;
    }

    public int getTooltipsPopupMaxWidth() {
        return CommonMultiblockScreen.parseTooltipsPopupMaxWidthFromLang((String)"gui.bigreactors.tooltips.popup_max_width", (int)220);
    }

    private void initialize() {
        this.setContentBounds(10, 0, this.getGuiWidth(), this.getGuiHeight() - 6);
        this.setTheme(GuiTheme.ER.get());
    }
}

