/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.energizer;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import it.zerono.mods.extremereactors.Log;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.AbstractEnergyGeneratorMultiblockController;
import it.zerono.mods.extremereactors.gamecontent.multiblock.energizer.part.AbstractEnergizerEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.energizer.part.EnergizerChargingPortEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.energizer.part.EnergizerControllerEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.energizer.part.EnergizerPowerPortEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.energizer.variant.EnergizerVariant;
import it.zerono.mods.extremereactors.gamecontent.multiblock.energizer.variant.IMultiblockEnergizerVariant;
import it.zerono.mods.zerocore.base.multiblock.part.io.power.IPowerPort;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.IActivableMachine;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.IDebuggable;
import it.zerono.mods.zerocore.lib.block.ModBlock;
import it.zerono.mods.zerocore.lib.data.WideAmount;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.data.stack.OperationMode;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import it.zerono.mods.zerocore.lib.energy.MeteredWideEnergyBuffer;
import it.zerono.mods.zerocore.lib.energy.WideEnergyBuffer;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockMachine;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockPart;
import it.zerono.mods.zerocore.lib.multiblock.validation.IMultiblockValidator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.LogicalSide;

public class MultiBlockEnergizer
extends AbstractEnergyGeneratorMultiblockController<MultiBlockEnergizer, IMultiblockEnergizerVariant>
implements IMultiblockMachine,
IActivableMachine,
ISyncableEntity,
IDebuggable {
    private final MeteredWideEnergyBuffer _meteredBuffer = (MeteredWideEnergyBuffer)this.getEnergyBuffer();
    private List<IPowerPort> _outputPowerPorts = ObjectLists.emptyList();

    public MultiBlockEnergizer(Level world) {
        super(world);
    }

    @Override
    protected WideEnergyBuffer createBuffer(EnergySystem system, WideAmount capacity) {
        return new MeteredWideEnergyBuffer(system, capacity);
    }

    public WideAmount getEnergyIoRate(EnergySystem system) {
        return this._meteredBuffer.getIoRateLastTick(system);
    }

    public WideAmount getEnergyInsertedLastTick(EnergySystem system) {
        return this._meteredBuffer.getInsertedLastTick(system);
    }

    public WideAmount getEnergyExtractedLastTick(EnergySystem system) {
        return this._meteredBuffer.getExtractedLastTick(system);
    }

    public void reset() {
        this.setMachineActive(false);
        this.getEnergyBuffer().empty();
    }

    @Override
    public WideAmount insertEnergy(EnergySystem system, WideAmount maxAmount, OperationMode mode) {
        if (this.isMachineActive()) {
            return super.insertEnergy(system, maxAmount, mode);
        }
        return WideAmount.ZERO;
    }

    @Override
    public WideAmount extractEnergy(EnergySystem system, WideAmount maxAmount, OperationMode mode) {
        if (this.isMachineActive()) {
            return super.extractEnergy(system, maxAmount, mode);
        }
        return WideAmount.ZERO;
    }

    public boolean isMachineActive() {
        return this._active;
    }

    public void setMachineActive(boolean active) {
        if (this.isMachineActive() == active) {
            return;
        }
        this._active = active;
        if (active) {
            this.getConnectedParts().forEach(IMultiblockPart::onMachineActivated);
        } else {
            this.getConnectedParts().forEach(IMultiblockPart::onMachineDeactivated);
        }
        this.callOnLogicalServer(() -> this.markReferenceCoordForUpdate());
    }

    @Override
    public void syncDataFrom(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        super.syncDataFrom(data, syncReason);
        this.syncBooleanElementFrom("active", data, b -> {
            this._active = b;
        });
    }

    @Override
    public CompoundTag syncDataTo(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        super.syncDataTo(data, syncReason);
        this.syncBooleanElementTo("active", data, this.isMachineActive());
        return data;
    }

    public void getDebugMessages(LogicalSide side, IDebugMessages messages) {
        if (!this.isAssembled()) {
            return;
        }
        this._meteredBuffer.getDebugMessages(side, messages);
    }

    public IMultiblockEnergizerVariant getVariant() {
        return EnergizerVariant.INSTANCE;
    }

    protected void sendClientUpdates() {
        ProfilerFiller profiler = this.getWorld().m_46473_();
        profiler.m_6180_("sendTickUpdate");
        this.sendUpdates();
        profiler.m_7238_();
    }

    public boolean isPartCompatible(IMultiblockPart<MultiBlockEnergizer> part) {
        return part instanceof AbstractEnergizerEntity;
    }

    protected void onPartAdded(IMultiblockPart<MultiBlockEnergizer> newPart) {
        if (newPart instanceof EnergizerChargingPortEntity || newPart instanceof EnergizerPowerPortEntity) {
            if (ObjectLists.emptyList() == this._outputPowerPorts) {
                this._outputPowerPorts = new ObjectArrayList(4);
            }
            this._outputPowerPorts.add((IPowerPort)newPart);
        }
    }

    protected void onPartRemoved(IMultiblockPart<MultiBlockEnergizer> oldPart) {
        if ((oldPart instanceof EnergizerChargingPortEntity || oldPart instanceof EnergizerPowerPortEntity) && ObjectLists.emptyList() != this._outputPowerPorts) {
            this._outputPowerPorts.remove(oldPart);
        }
    }

    protected void onMachineAssembled() {
        this.getEnergyBuffer().setCapacity(this.getVariant().getStorageCapacityPerBlock().multiply((long)this.getBoundingBox().getInternalVolume()));
        this.getEnergyBuffer().setMaxTransfer(this.getVariant().getMaxEnergyExtractionRate());
        this.callOnLogicalSide(() -> this.markReferenceCoordForUpdate(), () -> this.markMultiblockForRenderUpdate());
        super.onMachineAssembled();
    }

    protected void onMachineDisassembled() {
        this.setMachineActive(false);
        this._active = false;
        this.markMultiblockForRenderUpdate();
    }

    protected boolean isMachineWhole(IMultiblockValidator validatorCallback) {
        if (!this.isAnyPartConnected(part -> part instanceof EnergizerControllerEntity)) {
            validatorCallback.setLastError("multiblock.validation.energizer.too_few_controllers", new Object[0]);
            return false;
        }
        return super.isMachineWhole(validatorCallback);
    }

    protected void onAssimilate(IMultiblockController<MultiBlockEnergizer> assimilated) {
        if (!(assimilated instanceof MultiBlockEnergizer)) {
            Log.LOGGER.warn(Log.ENERGIZER, "[{}] Energizer @ {} is attempting to assimilate a non-Energizer machine! That machine's data will be lost!", (Object)CodeHelper.getWorldSideName((Level)this.getWorld()), (Object)this.getReferenceCoord());
            return;
        }
        MultiBlockEnergizer otherEnergizer = (MultiBlockEnergizer)assimilated;
        this.getEnergyBuffer().merge(otherEnergizer.getEnergyBuffer());
    }

    protected void onAssimilated(IMultiblockController<MultiBlockEnergizer> assimilator) {
        this._outputPowerPorts.clear();
    }

    protected boolean updateServer() {
        ProfilerFiller profiler = this.getWorld().m_46473_();
        profiler.m_6180_("Extreme Reactors|Energizer update");
        profiler.m_6180_("Charging");
        if (this.isMachineActive()) {
            this.distributeEnergyEqually();
        }
        profiler.m_6182_("Tickables");
        this._meteredBuffer.tick();
        profiler.m_6182_("Updates");
        this.checkAndSendClientUpdates();
        profiler.m_6182_("Mark4Update");
        profiler.m_7238_();
        profiler.m_7238_();
        return this.getEnergyBuffer().modified();
    }

    protected boolean isBlockGoodForFrame(Level world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        return MultiBlockEnergizer.invalidBlockForExterior(world, x, y, z, validatorCallback);
    }

    protected boolean isBlockGoodForTop(Level world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        return MultiBlockEnergizer.invalidBlockForExterior(world, x, y, z, validatorCallback);
    }

    protected boolean isBlockGoodForBottom(Level world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        return MultiBlockEnergizer.invalidBlockForExterior(world, x, y, z, validatorCallback);
    }

    protected boolean isBlockGoodForSides(Level world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        return MultiBlockEnergizer.invalidBlockForExterior(world, x, y, z, validatorCallback);
    }

    protected boolean isBlockGoodForInterior(Level world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        BlockPos position = new BlockPos(x, y, z);
        BlockState blockState = world.m_8055_(position);
        if (blockState.m_60713_((Block)Content.Blocks.ENERGIZER_CELL.get())) {
            return true;
        }
        validatorCallback.setLastError(position, "multiblock.validation.energizer.invalid_block_for_interior", new Object[]{ModBlock.getNameForTranslation((Block)blockState.m_60734_())});
        return false;
    }

    private static boolean invalidBlockForExterior(Level world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        BlockPos position = new BlockPos(x, y, z);
        validatorCallback.setLastError(position, "multiblock.validation.energizer.invalid_block_for_exterior", new Object[]{ModBlock.getNameForTranslation((Block)world.m_8055_(position).m_60734_())});
        return false;
    }

    private void distributeEnergyEqually() {
        WideEnergyBuffer energyBuffer = this.getEnergyBuffer();
        WideAmount amountDistributed = MultiBlockEnergizer.distributeEnergyEqually(energyBuffer.getEnergyStored(), this._outputPowerPorts);
        if (amountDistributed.greaterThan(WideAmount.ZERO)) {
            energyBuffer.shrink(amountDistributed);
        }
    }
}

